/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.entity.misc.AircraftProperties;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class QuadrocopterEntity
extends Rotorcraft {
    private final AircraftProperties properties = new AircraftProperties(this).setYawSpeed(5.0f).setPitchSpeed(1.5f).setEngineSpeed(0.0325f).setVerticalSpeed(0.0325f).setGlideFactor(0.0f).setDriftDrag(0.005f).setLift(0.1f).setRollFactor(15.0f).setWindSensitivity(0.0125f).setMass(1.0f);
    private static final VehicleInventoryDescription inventoryDescription = new VehicleInventoryDescription().addSlot(VehicleInventoryDescription.SlotType.BOILER, 17, 22).addSlot(VehicleInventoryDescription.SlotType.WEAPON, 50, 14).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 72, 14).addSlots(VehicleInventoryDescription.SlotType.INVENTORY, 98, 8, 3, 2).build();
    final List<List<Vector3d>> PASSENGER_POSITIONS = Collections.singletonList(Collections.singletonList(new Vector3d(0.0, (double)0.275f, (double)-0.1f)));

    @Override
    public VehicleInventoryDescription getInventoryDescription() {
        return inventoryDescription;
    }

    public QuadrocopterEntity(EntityType<? extends AircraftEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float getBaseFuelConsumption() {
        return 0.5f;
    }

    @Override
    protected float getInputInterpolationSteps() {
        return 5.0f;
    }

    @Override
    protected SoundEvent getEngineSound() {
        return Sounds.PROPELLER_TINY.get();
    }

    @Override
    protected float getEnginePitch() {
        return 1.0f;
    }

    @Override
    public AircraftProperties getProperties() {
        return this.properties;
    }

    @Override
    protected float getGroundVelocityDecay() {
        return 0.25f;
    }

    @Override
    protected float getHorizontalVelocityDelay() {
        return 0.9f;
    }

    @Override
    protected float getVerticalVelocityDelay() {
        return 0.8f;
    }

    @Override
    protected float getStabilizer() {
        return 0.1f;
    }

    @Override
    public Item asItem() {
        return Items.QUADROCOPTER.get();
    }

    @Override
    protected List<List<Vector3d>> getPassengerPositions() {
        return this.PASSENGER_POSITIONS;
    }

    @Override
    protected float getGravity() {
        return this.field_70171_ac ? 0.04f : (1.0f - this.getEnginePower()) * super.getGravity();
    }

    @Override
    protected void updateController() {
        super.updateController();
        this.setEngineTarget(1.0f);
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)(this.getEnginePower() * this.properties.getVerticalSpeed() * this.pressingInterpolatedY.getSmooth()), 0.0));
        Vector3d direction = this.getDirection();
        float thrust = (float)(Math.pow(this.getEnginePower(), 5.0) * (double)this.properties.getEngineSpeed()) * this.pressingInterpolatedZ.getSmooth();
        this.func_213317_d(this.func_213322_ci().func_178787_e(direction.func_186678_a((double)thrust)));
    }
}

