/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import com.google.common.collect.Lists;
import immersive_aircraft.client.KeyBindings;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.compat.Matrix3f;
import immersive_aircraft.compat.Matrix4f;
import immersive_aircraft.compat.Vec3f;
import immersive_aircraft.compat.Vector4f;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.network.c2s.CollisionMessage;
import immersive_aircraft.network.c2s.CommandMessage;
import immersive_aircraft.util.InterpolatedFloat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public abstract class VehicleEntity
extends Entity {
    protected static final DataParameter<Integer> DAMAGE_WOBBLE_TICKS = EntityDataManager.func_187226_a(VehicleEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> DAMAGE_WOBBLE_SIDE = EntityDataManager.func_187226_a(VehicleEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Float> DAMAGE_WOBBLE_STRENGTH = EntityDataManager.func_187226_a(VehicleEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> BOOST = EntityDataManager.func_187226_a(VehicleEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected int interpolationSteps;
    protected double x;
    protected double y;
    protected double z;
    protected double clientYaw;
    protected double clientPitch;
    protected float movementX;
    protected float movementY;
    protected float movementZ;
    public final InterpolatedFloat pressingInterpolatedX;
    public final InterpolatedFloat pressingInterpolatedY;
    public final InterpolatedFloat pressingInterpolatedZ;
    public float roll;
    public float prevRoll;
    protected static final Vector4f ZERO_VEC4 = new Vector4f();

    public float getRoll() {
        return this.roll;
    }

    public float getRoll(float tickDelta) {
        return MathHelper.func_219799_g((float)tickDelta, (float)this.prevRoll, (float)this.getRoll());
    }

    public void boost() {
        this.field_70180_af.func_187227_b(BOOST, (Object)100);
    }

    protected void applyBoost() {
    }

    public boolean canBoost() {
        return false;
    }

    public int getBoost() {
        return (Integer)this.field_70180_af.func_187225_a(BOOST);
    }

    protected abstract List<List<Vector3d>> getPassengerPositions();

    protected int getPassengerSpace() {
        return this.getPassengerPositions().size();
    }

    public void setPitch(float pitch) {
        float loops = (float)(Math.floor((pitch + 180.0f) / 360.0f) * 360.0);
        this.field_70127_C -= loops;
        this.field_70125_A = pitch -= loops;
    }

    public VehicleEntity(EntityType<? extends AircraftEntity> entityType, World world) {
        super(entityType, world);
        this.field_70138_W = 0.55f;
        this.pressingInterpolatedX = new InterpolatedFloat(this.getInputInterpolationSteps());
        this.pressingInterpolatedY = new InterpolatedFloat(this.getInputInterpolationSteps());
        this.pressingInterpolatedZ = new InterpolatedFloat(this.getInputInterpolationSteps());
    }

    protected float getInputInterpolationSteps() {
        return 10.0f;
    }

    protected float func_213316_a(Pose pose, EntitySize dimensions) {
        return dimensions.field_220316_b;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DAMAGE_WOBBLE_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(DAMAGE_WOBBLE_SIDE, (Object)1);
        this.field_70180_af.func_187214_a(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(BOOST, (Object)0);
    }

    public boolean func_241849_j(Entity other) {
        return AircraftEntity.canCollide(this, other);
    }

    public static boolean canCollide(Entity entity, Entity other) {
        return (other.func_241845_aY() || other.func_70104_M()) && !entity.func_184223_x(other);
    }

    public boolean func_241845_aY() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    protected Vector3d func_241839_a(Direction.Axis axis, TeleportationRepositioner.Result rectangle) {
        return LivingEntity.func_242288_h((Vector3d)super.func_241839_a(axis, rectangle));
    }

    public boolean func_85031_j(Entity attacker) {
        return this.func_184196_w(attacker) || super.func_85031_j(attacker);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean bl;
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_70170_p.field_72995_K || this.isRemoved()) {
            return true;
        }
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.setDamageWobbleStrength(this.getDamageWobbleStrength() + amount * 10.0f / this.getDurability());
        boolean bl2 = bl = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
        if ((bl || this.getDamageWobbleStrength() > 40.0f) && (!Config.getInstance().onlyPlayerCanDestroyAircraft || this.func_184207_aI() || source.func_76346_g() instanceof PlayerEntity)) {
            if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                this.drop();
            }
            this.func_70106_y();
        }
        return true;
    }

    protected float getDurability() {
        return 1.0f;
    }

    protected void drop() {
        this.func_199703_a((IItemProvider)this.asItem());
    }

    public void func_203002_i(boolean drag) {
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() + (double)this.field_70146_Z.nextFloat(), this.func_226278_cu_() + 0.7, this.func_226281_cx_() + (double)this.field_70146_Z.nextFloat(), 0.0, 0.0, 0.0);
        if (this.field_70146_Z.nextInt(20) == 0) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_184181_aa(), this.func_184176_by(), 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat(), false);
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() + (double)this.field_70146_Z.nextFloat(), this.func_226278_cu_() + 0.7, this.func_226281_cx_() + (double)this.field_70146_Z.nextFloat(), 0.0, 0.0, 0.0);
    }

    public void func_70108_f(Entity entity) {
        if (entity instanceof AircraftEntity) {
            if (entity.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entity);
            }
        } else if (entity.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entity);
        }
    }

    public Item asItem() {
        return Items.field_185154_aL;
    }

    public void func_70057_ab() {
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.setDamageWobbleStrength(this.getDamageWobbleStrength() * 11.0f);
    }

    public boolean func_70067_L() {
        return !this.isRemoved();
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.clientYaw = yaw;
        this.clientPitch = pitch;
        this.interpolationSteps = 10;
    }

    public Direction func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    private static float getMovementMultiplier(boolean positive, boolean negative) {
        if (positive == negative) {
            return 0.0f;
        }
        return positive ? 1.0f : -1.0f;
    }

    protected boolean useAirplaneControls() {
        return false;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.func_201670_d() && this.func_184188_bt().size() > 0) {
            for (Entity entity : this.func_184188_bt()) {
                if (!(entity instanceof ClientPlayerEntity)) continue;
                if (KeyBindings.dismount.func_151468_f()) {
                    NetworkHandler.sendToServer(new CommandMessage(CommandMessage.Key.DISMOUNT, this.func_213322_ci()));
                }
                if (!KeyBindings.boost.func_151468_f() || !this.canBoost()) continue;
                NetworkHandler.sendToServer(new CommandMessage(CommandMessage.Key.BOOST, this.func_213322_ci()));
                Vector3d p = this.func_213303_ch();
                this.field_70170_p.func_184134_a(p.func_82615_a(), p.func_82617_b(), p.func_82616_c(), SoundEvents.field_187631_bo, SoundCategory.NEUTRAL, 1.0f, 1.0f, true);
            }
            Entity pilot = (Entity)this.func_184188_bt().get(0);
            if (pilot instanceof ClientPlayerEntity) {
                this.setInputs(VehicleEntity.getMovementMultiplier(KeyBindings.left.func_151470_d(), KeyBindings.right.func_151470_d()), VehicleEntity.getMovementMultiplier(KeyBindings.up.func_151470_d(), KeyBindings.down.func_151470_d()), VehicleEntity.getMovementMultiplier(this.useAirplaneControls() ? KeyBindings.push.func_151470_d() : KeyBindings.forward.func_151470_d(), this.useAirplaneControls() ? KeyBindings.pull.func_151470_d() : KeyBindings.backward.func_151470_d()));
            }
        }
        if (this.getDamageWobbleTicks() > 0) {
            this.setDamageWobbleTicks(this.getDamageWobbleTicks() - 1);
        }
        if (this.getDamageWobbleStrength() > 0.0f) {
            this.setDamageWobbleStrength(this.getDamageWobbleStrength() - 1.0f);
        }
        super.func_70071_h_();
        this.handleClientSync();
        int boost = this.getBoost();
        if (boost > 0) {
            this.field_70180_af.func_187227_b(BOOST, (Object)(boost - 1));
        }
        if (this.func_184186_bw()) {
            this.updateVelocity();
            if (boost > 0) {
                this.applyBoost();
            }
            if (this.field_70170_p.field_72995_K) {
                this.updateController();
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        }
        this.func_145775_I();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), EntityPredicates.func_200823_a((Entity)this));
        if (!list.isEmpty()) {
            boolean bl = !this.field_70170_p.field_72995_K && !(this.func_184179_bs() instanceof PlayerEntity);
            for (Entity entity : list) {
                if (entity.func_184196_w((Entity)this)) continue;
                if (bl && this.func_184188_bt().size() < this.getPassengerSpace() - 1 && !entity.func_184218_aH() && entity.func_213311_cf() < this.func_213311_cf() && entity instanceof LivingEntity && !(entity instanceof WaterMobEntity) && !(entity instanceof PlayerEntity)) {
                    entity.func_184220_m((Entity)this);
                    continue;
                }
                this.func_70108_f(entity);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.pressingInterpolatedX.update(this.movementX);
            this.pressingInterpolatedY.update(this.movementY);
            this.pressingInterpolatedZ.update(this.movementZ);
        }
    }

    private void handleClientSync() {
        if (this.func_184186_bw()) {
            this.interpolationSteps = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedX = this.func_226277_ct_() + (this.x - this.func_226277_ct_()) / (double)this.interpolationSteps;
        double interpolatedY = this.func_226278_cu_() + (this.y - this.func_226278_cu_()) / (double)this.interpolationSteps;
        double interpolatedZ = this.func_226281_cx_() + (this.z - this.func_226281_cx_()) / (double)this.interpolationSteps;
        double interpolatedYaw = MathHelper.func_76138_g((double)(this.clientYaw - (double)this.getYaw()));
        this.setYaw(this.getYaw() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.setPitch(this.getPitch() + (float)(this.clientPitch - (double)this.getPitch()) / (float)this.interpolationSteps);
        this.func_70107_b(interpolatedX, interpolatedY, interpolatedZ);
        this.func_70101_b(this.getYaw(), this.getPitch());
        --this.interpolationSteps;
    }

    protected abstract void updateVelocity();

    protected float getGravity() {
        return -0.04f;
    }

    protected abstract void updateController();

    public void func_184232_k(Entity passenger) {
        int i;
        List<List<Vector3d>> positions;
        if (!this.func_184196_w(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform();
        int size = this.func_184188_bt().size() - 1;
        if (size < (positions = this.getPassengerPositions()).size() && (i = this.func_184188_bt().indexOf(passenger)) >= 0 && i < positions.get(size).size()) {
            Vector3d position = positions.get(size).get(i);
            if (passenger instanceof AnimalEntity) {
                position.func_72441_c(0.0, 0.0, (double)0.2f);
            }
            position = position.func_72441_c(0.0, passenger.func_70033_W(), 0.0);
            Vector4f worldPosition = this.transformPosition(transform, (float)position.field_72450_a, (float)position.field_72448_b, (float)position.field_72449_c);
            passenger.func_70107_b((double)worldPosition.getX(), (double)worldPosition.getY(), (double)worldPosition.getZ());
            passenger.field_70177_z += this.getYaw() - this.field_70126_B;
            passenger.func_70034_d(passenger.func_70079_am() + (this.getYaw() - this.field_70126_B));
            this.copyEntityData(passenger);
            if (passenger instanceof AnimalEntity && size > 1) {
                int angle = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((AnimalEntity)passenger).field_70761_aq + (float)angle);
                passenger.func_70034_d(passenger.func_70079_am() + (float)angle);
            }
        }
    }

    private Vector3d getDismountOffset(double vehicleWidth, double passengerWidth) {
        double d = (vehicleWidth + passengerWidth + (double)1.0E-5f) / 2.0;
        float yaw = this.getYaw() + 90.0f;
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180)));
        float g = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180)));
        float h = Math.max(Math.abs(f), Math.abs(g));
        return new Vector3d((double)f * d / (double)h, 0.0, (double)g * d / (double)h);
    }

    public Vector3d func_230268_c_(LivingEntity passenger) {
        if (this.func_213322_ci().func_189985_c() < (double)0.1f) {
            double e;
            Vector3d vec3d = this.getDismountOffset(this.func_213311_cf() * MathHelper.field_180189_a, passenger.func_213311_cf());
            double d = this.func_226277_ct_() + vec3d.field_72450_a;
            BlockPos blockPos = new BlockPos(d, this.func_174813_aQ().field_72337_e, e = this.func_226281_cx_() + vec3d.field_72449_c);
            BlockPos blockPos2 = blockPos.func_177977_b();
            if (!this.field_70170_p.func_201671_F(blockPos2)) {
                double g;
                ArrayList list = Lists.newArrayList();
                double f = this.field_70170_p.func_242403_h(blockPos);
                if (TransportationHelper.func_234630_a_((double)f)) {
                    list.add(new Vector3d(d, (double)blockPos.func_177956_o() + f, e));
                }
                if (TransportationHelper.func_234630_a_((double)(g = this.field_70170_p.func_242403_h(blockPos2)))) {
                    list.add(new Vector3d(d, (double)blockPos2.func_177956_o() + g, e));
                }
                for (Pose entityPose : passenger.func_230297_ef_()) {
                    for (Vector3d vec3d2 : list) {
                        Vector3d vec3d3 = TransportationHelper.func_242381_a((ICollisionReader)this.field_70170_p, (double)d, (double)g, (double)e, (LivingEntity)passenger, (Pose)entityPose);
                        if (vec3d3 == null) continue;
                        passenger.func_213301_b(entityPose);
                        return vec3d2;
                    }
                }
            }
        }
        return super.func_230268_c_(passenger);
    }

    protected void copyEntityData(Entity entity) {
        entity.func_181013_g(this.getYaw());
        float f = MathHelper.func_76142_g((float)(entity.field_70177_z - this.getYaw()));
        float g = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entity.field_70126_B += g - f;
        entity.field_70177_z = entity.field_70177_z + g - f;
        entity.func_70034_d(entity.field_70177_z);
    }

    public void func_184190_l(Entity passenger) {
        this.copyEntityData(passenger);
    }

    protected void func_213281_b(CompoundNBT nbt) {
    }

    protected void func_70037_a(CompoundNBT nbt) {
    }

    public boolean func_189652_ae() {
        return true;
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (player.func_226563_dT_()) {
            return ActionResultType.PASS;
        }
        if (this.func_184196_w((Entity)player)) {
            return ActionResultType.PASS;
        }
        if (!this.field_70170_p.field_72995_K && !player.func_184218_aH()) {
            return player.func_184220_m((Entity)this) ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }

    public void func_213315_a(MoverType movementType, Vector3d movement) {
        Vector3d prediction = this.func_213303_ch().func_178787_e(movement);
        super.func_213315_a(movementType, movement);
        if (this.field_70170_p.field_72995_K && Config.getInstance().collisionDamage && (this.field_70124_G || this.field_70123_F)) {
            float repeat;
            float collision;
            double maxPossibleError = movement.func_72433_c();
            double error = prediction.func_72438_d(this.func_213303_ch());
            if (error <= maxPossibleError && (collision = (float)(error - (this.field_70124_G ? (double)Math.abs(this.getGravity()) : 0.0))) > 0.01f && (repeat = 1.0f - (float)(this.getDamageWobbleTicks() + 1) / 10.0f) > 1.0E-4f) {
                float damage = collision * 20.0f * repeat * repeat;
                NetworkHandler.sendToServer(new CollisionMessage(damage));
            }
        }
    }

    protected void func_184231_a(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public void setDamageWobbleStrength(float wobbleStrength) {
        this.field_70180_af.func_187227_b(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(wobbleStrength));
    }

    public float getDamageWobbleStrength() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_WOBBLE_STRENGTH)).floatValue();
    }

    public void setDamageWobbleTicks(int wobbleTicks) {
        this.field_70180_af.func_187227_b(DAMAGE_WOBBLE_TICKS, (Object)wobbleTicks);
    }

    public int getDamageWobbleTicks() {
        return (Integer)this.field_70180_af.func_187225_a(DAMAGE_WOBBLE_TICKS);
    }

    public void setDamageWobbleSide(int side) {
        this.field_70180_af.func_187227_b(DAMAGE_WOBBLE_SIDE, (Object)side);
    }

    public int getDamageWobbleSide() {
        return (Integer)this.field_70180_af.func_187225_a(DAMAGE_WOBBLE_SIDE);
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < this.getPassengerSpace() && !this.func_208600_a((ITag)FluidTags.field_206959_a);
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.getFirstPassenger();
    }

    public void setInputs(float x, float y, float z) {
        this.movementX = x;
        this.movementY = y;
        this.movementZ = z;
    }

    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }

    public boolean isWithinParticleRange() {
        return Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c().func_72436_e(this.func_213303_ch()) < 1024.0;
    }

    protected Vector4f transformPosition(Matrix4f transform, float x, float y, float z) {
        Vector4f p0 = new Vector4f(x, y, z, 1.0f);
        p0.transform(transform);
        return p0;
    }

    protected Vec3f transformVector(float x, float y, float z) {
        return this.transformVector(this.getVehicleNormalTransform(), x, y, z);
    }

    protected Vec3f transformVector(Matrix3f transform, float x, float y, float z) {
        Vec3f p0 = new Vec3f(x, y, z);
        p0.transform(transform);
        return p0;
    }

    protected Matrix4f getVehicleTransform() {
        Matrix4f transform = Matrix4f.translate((float)this.func_226277_ct_(), (float)this.func_226278_cu_(), (float)this.func_226281_cx_());
        transform.multiply(Vec3f.POSITIVE_Y.getDegreesQuaternion(-this.getYaw()));
        transform.multiply(Vec3f.POSITIVE_X.getDegreesQuaternion(this.getPitch()));
        transform.multiply(Vec3f.POSITIVE_Z.getDegreesQuaternion(this.getRoll()));
        return transform;
    }

    protected Matrix3f getVehicleNormalTransform() {
        Matrix3f transform = Matrix3f.scale(1.0f, 1.0f, 1.0f);
        transform.multiply(Vec3f.POSITIVE_Y.getDegreesQuaternion(-this.getYaw()));
        transform.multiply(Vec3f.POSITIVE_X.getDegreesQuaternion(this.getPitch()));
        transform.multiply(Vec3f.POSITIVE_Z.getDegreesQuaternion(this.getRoll()));
        return transform;
    }

    public Vector3d getDirection() {
        Vec3f f = this.transformVector(0.0f, 0.0f, 1.0f);
        return new Vector3d((double)f.getX(), (double)f.getY(), (double)f.getZ());
    }

    public Vector3d getTopDirection() {
        Vec3f f = this.transformVector(0.0f, 1.0f, 0.0f);
        return new Vector3d((double)f.getX(), (double)f.getY(), (double)f.getZ());
    }

    public boolean func_70112_a(double distance) {
        double d = (double)Config.getInstance().renderDistance * VehicleEntity.func_184183_bd();
        return distance < d * d;
    }

    public void chill() {
    }

    public float getYaw() {
        return this.field_70177_z;
    }

    public boolean isRemoved() {
        return this.field_70128_L;
    }

    public void setYaw(float yaw) {
        this.field_70177_z = yaw;
    }

    public float getPitch() {
        return this.field_70125_A;
    }

    @Nullable
    public Entity getFirstPassenger() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }
}

