/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.misc;

import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.network.c2s.RequestInventory;
import immersive_aircraft.network.s2c.InventoryUpdateMessage;
import immersive_aircraft.screen.VehicleScreenHandler;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;

public class SparseSimpleInventory
extends Inventory {
    private final NonNullList<ItemStack> tracked;
    private boolean inventoryRequested = false;

    public SparseSimpleInventory(int size) {
        super(size);
        this.tracked = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    public ListNBT writeNbt(ListNBT nbtList) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            CompoundNBT nbtCompound = new CompoundNBT();
            nbtCompound.func_74774_a("Slot", (byte)i);
            this.func_70301_a(i).func_77955_b(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        return nbtList;
    }

    public void readNbt(ListNBT nbtList) {
        this.func_174888_l();
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundNBT nbtCompound = nbtList.func_150305_b(i);
            int slot = nbtCompound.func_74771_c("Slot") & 0xFF;
            ItemStack itemStack = ItemStack.func_199557_a((CompoundNBT)nbtCompound);
            if (itemStack.func_190926_b()) continue;
            this.func_70299_a(slot, itemStack);
        }
    }

    public void tick(InventoryVehicleEntity entity) {
        if (entity.field_70170_p.field_72995_K) {
            if (!this.inventoryRequested) {
                NetworkHandler.sendToServer(new RequestInventory(entity.func_145782_y()));
                this.inventoryRequested = true;
            }
        } else {
            ItemStack trackedStack;
            int index = entity.field_70173_aa % entity.getInventoryDescription().getLastSyncIndex();
            ItemStack stack = this.func_70301_a(index);
            if (!stack.equals(trackedStack = (ItemStack)this.tracked.get(index))) {
                this.tracked.set(index, (Object)stack);
                entity.field_70170_p.func_217369_A().forEach(p -> {
                    if (!(p.field_71070_bA instanceof VehicleScreenHandler) || ((VehicleScreenHandler)p.field_71070_bA).getVehicle() != entity) {
                        NetworkHandler.sendToPlayer(new InventoryUpdateMessage(entity.func_145782_y(), index, stack), (ServerPlayerEntity)p);
                    }
                });
            }
        }
    }
}

