/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.forge.cobalt.registration;

import immersive_aircraft.cobalt.registration.Registration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class RegistrationImpl
extends Registration.Impl {
    public static final RegistrationImpl IMPL = new RegistrationImpl();
    private final Map<String, RegistryRepo> repos = new HashMap<String, RegistryRepo>();

    public static void bootstrap() {
    }

    private RegistryRepo getRepo(String namespace) {
        return this.repos.computeIfAbsent(namespace, RegistryRepo::new);
    }

    @Override
    public <T extends Entity> void registerEntityRenderer(EntityType<T> type, Function<EntityRendererManager, EntityRenderer<T>> constructor) {
        RenderingRegistry.registerEntityRenderingHandler(type, constructor::apply);
    }

    @Override
    public <T> Supplier<T> register(Registry<? super T> registry, ResourceLocation id, Supplier<T> obj) {
        DeferredRegister reg = this.getRepo(id.func_110624_b()).get(registry);
        return reg.register(id.func_110623_a(), obj);
    }

    @Override
    public ItemGroup itemGroup(ResourceLocation id, final Supplier<ItemStack> icon) {
        return new ItemGroup(ItemGroup.getGroupCountSafe(), String.format("%s.%s", id.func_110624_b(), id.func_110623_a())){

            public ItemStack func_78016_d() {
                return (ItemStack)icon.get();
            }
        };
    }

    static class RegistryRepo {
        private final Set<ResourceLocation> skipped = new HashSet<ResourceLocation>();
        private final Map<ResourceLocation, DeferredRegister<?>> registries = new HashMap();
        private final String namespace;

        public RegistryRepo(String namespace) {
            this.namespace = namespace;
        }

        public <T> DeferredRegister get(Registry<? super T> registry) {
            ResourceLocation id = registry.func_243578_f().func_240901_a_();
            if (!this.registries.containsKey(id) && !this.skipped.contains(id)) {
                ForgeRegistry reg = RegistryManager.ACTIVE.getRegistry(id);
                if (reg == null) {
                    this.skipped.add(id);
                    return null;
                }
                DeferredRegister def = DeferredRegister.create((IForgeRegistry)((IForgeRegistry)Objects.requireNonNull(reg, "Registry=" + id)), (String)this.namespace);
                def.register(FMLJavaModLoadingContext.get().getModEventBus());
                this.registries.put(id, def);
            }
            return this.registries.get(id);
        }
    }
}

