/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.item;

import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.util.FlowingText;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class AircraftItem
extends Item {
    private static final Predicate<Entity> RIDERS = EntityPredicates.field_180132_d.and(Entity::func_70067_L);
    private final AircraftConstructor constructor;

    public AircraftItem(Item.Properties settings, AircraftConstructor constructor) {
        super(settings);
        this.constructor = constructor;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag context) {
        super.func_77624_a(stack, world, tooltip, context);
        tooltip.addAll(FlowingText.wrap((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".description").func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY), 180));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity user, Hand hand) {
        ItemStack itemStack = user.func_184586_b(hand);
        BlockRayTraceResult hitResult = AircraftItem.func_219968_a((World)world, (PlayerEntity)user, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (hitResult.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)itemStack);
        }
        Vector3d vec3d = user.func_70676_i(1.0f);
        List list = world.func_175674_a((Entity)user, user.func_174813_aQ().func_216361_a(vec3d.func_186678_a(5.0)).func_186662_g(1.0), RIDERS);
        if (!list.isEmpty()) {
            Vector3d vec3d2 = user.func_174824_e(1.0f);
            for (Entity entity : list) {
                AxisAlignedBB box = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
                if (!box.func_72318_a(vec3d2)) continue;
                return ActionResult.func_226250_c_((Object)itemStack);
            }
        }
        if (hitResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            AircraftEntity entity = this.constructor.create(world);
            entity.func_70107_b(hitResult.func_216347_e().field_72450_a, hitResult.func_216347_e().field_72448_b, hitResult.func_216347_e().field_72449_c);
            entity.field_70177_z = user.field_70177_z;
            if (!world.func_226665_a__((Entity)entity, entity.func_174813_aQ().func_186662_g(-0.1))) {
                return ActionResult.func_226251_d_((Object)itemStack);
            }
            if (!world.field_72995_K) {
                world.func_217376_c((Entity)entity);
                if (!user.field_71075_bZ.field_75098_d) {
                    itemStack.func_190918_g(1);
                }
            }
            user.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResult.func_233538_a_((Object)itemStack, (boolean)world.func_201670_d());
        }
        return ActionResult.func_226250_c_((Object)itemStack);
    }

    public static interface AircraftConstructor {
        public AircraftEntity create(World var1);
    }
}

