/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.network.c2s;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.VehicleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;

public class CollisionMessage
extends Message {
    private final float damage;

    public CollisionMessage(float damage) {
        this.damage = damage;
    }

    public CollisionMessage(PacketBuffer b) {
        this.damage = b.readFloat();
    }

    @Override
    public void encode(PacketBuffer b) {
        b.writeFloat(this.damage);
    }

    @Override
    public void receive(PlayerEntity e) {
        if (e.func_184208_bv() instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)e.func_184208_bv();
            vehicle.func_70097_a(DamageSource.field_76379_h, this.damage);
            if (vehicle.isRemoved()) {
                float crashDamage = this.damage * Config.getInstance().crashDamage;
                if (Config.getInstance().preventKillThroughCrash) {
                    crashDamage = Math.min(crashDamage, e.func_110143_aJ() - 1.0f);
                }
                e.func_70097_a(DamageSource.field_76379_h, crashDamage);
            }
        }
    }
}

