/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.network.c2s;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.VehicleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;

public class CommandMessage
extends Message {
    private final Key key;
    private final double fx;
    private final double fy;
    private final double fz;

    public CommandMessage(Key key, Vector3d velocity) {
        this.key = key;
        this.fx = velocity.field_72450_a;
        this.fy = velocity.field_72448_b;
        this.fz = velocity.field_72449_c;
    }

    public CommandMessage(PacketBuffer b) {
        this.key = Key.values()[b.readInt()];
        this.fx = b.readDouble();
        this.fy = b.readDouble();
        this.fz = b.readDouble();
    }

    @Override
    public void encode(PacketBuffer b) {
        b.writeInt(this.key.ordinal());
        b.writeDouble(this.fx);
        b.writeDouble(this.fy);
        b.writeDouble(this.fz);
    }

    @Override
    public void receive(PlayerEntity e) {
        VehicleEntity vehicle;
        if (e.func_184208_bv() instanceof VehicleEntity) {
            vehicle = (VehicleEntity)e.func_184208_bv();
            if (this.key == Key.DISMOUNT) {
                e.func_184210_p();
                vehicle.chill();
                vehicle.func_213293_j(this.fx, this.fy, this.fz);
            } else if (this.key == Key.BOOST && vehicle.canBoost()) {
                vehicle.boost();
            }
        }
        if (e.func_184208_bv() instanceof InventoryVehicleEntity) {
            vehicle = (InventoryVehicleEntity)e.func_184208_bv();
            if (this.key == Key.INVENTORY) {
                ((InventoryVehicleEntity)vehicle).openInventory((ServerPlayerEntity)e);
            }
        }
    }

    public static enum Key {
        DISMOUNT,
        INVENTORY,
        BOOST,
        DAMAGE;

    }
}

