/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.screen;

import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.item.UpgradeItem;
import immersive_aircraft.item.WeaponItem;
import immersive_aircraft.screen.slot.FuelSlot;
import immersive_aircraft.screen.slot.TypedSlot;
import immersive_aircraft.screen.slot.UpgradeSlot;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BannerItem;
import net.minecraft.item.DyeItem;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.ItemStack;

public class VehicleScreenHandler
extends Container {
    private final IInventory inventory;
    private final InventoryVehicleEntity vehicle;

    public VehicleScreenHandler(int syncId, PlayerInventory playerInventory, InventoryVehicleEntity vehicle) {
        super(null, syncId);
        this.vehicle = vehicle;
        this.inventory = vehicle.getInventory();
        this.inventory.func_174889_b(playerInventory.field_70458_d);
        int titleHeight = 10;
        for (VehicleInventoryDescription.Slot slot : this.vehicle.getInventoryDescription().getSlots()) {
            if (slot.type == VehicleInventoryDescription.SlotType.BOILER) {
                this.func_75146_a(new FuelSlot(this.inventory, slot.index, slot.x, slot.y + titleHeight));
                continue;
            }
            if (slot.type == VehicleInventoryDescription.SlotType.WEAPON) {
                this.func_75146_a(new TypedSlot(WeaponItem.class, 1, this.inventory, slot.index, slot.x, slot.y + titleHeight));
                continue;
            }
            if (slot.type == VehicleInventoryDescription.SlotType.UPGRADE) {
                this.func_75146_a(new UpgradeSlot(vehicle, UpgradeItem.class, 1, this.inventory, slot.index, slot.x, slot.y + titleHeight));
                continue;
            }
            if (slot.type == VehicleInventoryDescription.SlotType.BOOSTER) {
                this.func_75146_a(new TypedSlot(FireworkRocketItem.class, 64, this.inventory, slot.index, slot.x, slot.y + titleHeight));
                continue;
            }
            if (slot.type == VehicleInventoryDescription.SlotType.BANNER) {
                this.func_75146_a(new TypedSlot(BannerItem.class, 1, this.inventory, slot.index, slot.x, slot.y + titleHeight));
                continue;
            }
            if (slot.type == VehicleInventoryDescription.SlotType.DYE) {
                this.func_75146_a(new TypedSlot(DyeItem.class, 1, this.inventory, slot.index, slot.x, slot.y + titleHeight));
                continue;
            }
            this.func_75146_a(new Slot(this.inventory, slot.index, slot.x, slot.y + titleHeight));
        }
        int h = this.vehicle.getInventoryDescription().getHeight() + titleHeight * 2;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x + y * 9 + 9, 8 + x * 18, h + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInventory, x, 8 + x * 18, h + 58));
        }
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.vehicle.getInventory() == this.inventory && this.inventory.func_70300_a(player) && this.vehicle.func_70089_S() && this.vehicle.func_70032_d((Entity)player) < 8.0f;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack newStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot.func_75216_d()) {
            ItemStack originalStack = slot.func_75211_c();
            newStack = originalStack.func_77946_l();
            if (index < this.inventory.func_70302_i_() ? !this.func_75135_a(originalStack, this.inventory.func_70302_i_(), this.field_75151_b.size(), true) : !this.func_75135_a(originalStack, 0, this.inventory.func_70302_i_(), false)) {
                return ItemStack.field_190927_a;
            }
            if (originalStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return newStack;
    }

    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean unused) {
        ItemStack target;
        Slot slot;
        int i;
        boolean inserted = false;
        if (stack.func_77985_e()) {
            for (i = startIndex; !stack.func_190926_b() && i < endIndex; ++i) {
                int maxCount;
                slot = (Slot)this.field_75151_b.get(i);
                target = slot.func_75211_c();
                if (target.func_190926_b() || !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)target)) continue;
                int diff = target.func_190916_E() + stack.func_190916_E();
                if (diff <= (maxCount = slot.func_178170_b(stack))) {
                    stack.func_190920_e(0);
                    target.func_190920_e(diff);
                    slot.func_75218_e();
                    inserted = true;
                    continue;
                }
                if (target.func_190916_E() >= maxCount) continue;
                stack.func_190918_g(maxCount - target.func_190916_E());
                target.func_190920_e(maxCount);
                slot.func_75218_e();
                inserted = true;
            }
        }
        if (!stack.func_190926_b()) {
            for (i = startIndex; i < endIndex; ++i) {
                slot = (Slot)this.field_75151_b.get(i);
                target = slot.func_75211_c();
                int maxCount = slot.func_178170_b(target);
                if (!target.func_190926_b() || !slot.func_75214_a(stack)) continue;
                if (stack.func_190916_E() > maxCount) {
                    slot.func_75215_d(stack.func_77979_a(maxCount));
                } else {
                    slot.func_75215_d(stack.func_77979_a(stack.func_190916_E()));
                }
                slot.func_75218_e();
                inserted = true;
                break;
            }
        }
        return inserted;
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.inventory.func_174886_c(player);
    }

    public InventoryVehicleEntity getVehicle() {
        return this.vehicle;
    }
}

