/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.util;

import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.BannerItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.BannerTileEntity;

public class Utils {
    public static double cosNoise(double time) {
        return Utils.cosNoise(time, 5);
    }

    public static double cosNoise(double time, int layers) {
        double value = 0.0;
        for (int i = 0; i < layers; ++i) {
            value += Math.cos(time);
            time *= 1.3;
        }
        return value;
    }

    public static List<Pair<BannerPattern, DyeColor>> parseBannerItem(ItemStack banner) {
        DyeColor baseColor = ((BannerItem)banner.func_77973_b()).func_195948_b();
        CompoundNBT nbtCompound = banner.func_190925_c("BlockEntityTag");
        if (nbtCompound == null || !nbtCompound.func_74764_b("Patterns")) {
            return Collections.singletonList(Pair.of((Object)BannerPattern.BASE, (Object)baseColor));
        }
        ListNBT nbtList = nbtCompound.func_150295_c("Patterns", 10);
        return BannerTileEntity.func_230138_a_((DyeColor)baseColor, (ListNBT)nbtList);
    }
}

