/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import com.mojang.datafixers.util.Pair;
import immersive_aircraft.Main;
import immersive_aircraft.client.render.entity.renderer.AircraftEntityRenderer;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.BiplaneEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.util.Utils;
import immersive_aircraft.util.obj.Mesh;
import java.util.List;
import net.minecraft.class_1160;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;

public class BiplaneEntityRenderer<T extends BiplaneEntity>
extends AircraftEntityRenderer<T> {
    private static final class_2960 id = Main.locate("objects/biplane.obj");
    private final class_2960 texture;
    private final AircraftEntityRenderer.Model model = new AircraftEntityRenderer.Model(this).add(new AircraftEntityRenderer.Object(this, id, "frame")).add(new AircraftEntityRenderer.Object(this, id, "banners").setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        List<class_1799> slots = entity.getSlots(VehicleInventoryDescription.SlotType.BANNER);
        int i = 0;
        for (class_1799 slot : slots) {
            if (slot.method_7960() || !(slot.method_7909() instanceof class_1746)) continue;
            List<Pair<class_2582, class_1767>> patterns = Utils.parseBannerItem(slot);
            Mesh mesh = BiplaneEntityRenderer.getFaces(id, "banner_" + i++);
            BiplaneEntityRenderer.renderBanner(matrixStack, vertexConsumerProvider, light, mesh, true, patterns);
        }
    })).add(new AircraftEntityRenderer.Object(this, id, "propeller").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.method_22904(0.0, 0.3125, 0.0);
        matrixStack.method_22907(class_1160.field_20707.method_23214((float)((double)entity.engineRotation.getSmooth(tickDelta) * 100.0)));
        matrixStack.method_22904(0.0, -0.3125, 0.0);
    })).add(new AircraftEntityRenderer.Object(this, id, "elevator").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.method_22904(0.0, 0.0625, -2.5);
        matrixStack.method_22907(class_1160.field_20703.method_23214(-entity.pressingInterpolatedZ.getSmooth(tickDelta) * 20.0f));
        matrixStack.method_22904(0.0, -0.0625, 2.5);
    })).add(new AircraftEntityRenderer.Object(this, id, "rudder").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.method_22904(0.0, 0.0625, -2.5);
        matrixStack.method_22907(class_1160.field_20705.method_23214(entity.pressingInterpolatedX.getSmooth(tickDelta) * 18.0f));
        matrixStack.method_22904(0.0, -0.0625, 2.5);
    }));

    public BiplaneEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.field_4673 = 0.8f;
        this.texture = Main.locate("textures/entity/biplane.png");
    }

    @Override
    public void render(T entity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
        super.render(entity, yaw, tickDelta, matrixStack, vertexConsumerProvider, i);
    }

    public class_2960 getTexture(T AircraftEntity2) {
        return this.texture;
    }

    @Override
    protected AircraftEntityRenderer.Model getModel(AircraftEntity entity) {
        return this.model;
    }

    @Override
    protected class_1160 getPivot(AircraftEntity entity) {
        return new class_1160(0.0f, 0.4f, 0.05f);
    }
}

