/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.config;

import immersive_aircraft.config.Config;
import immersive_aircraft.config.configEntries.BooleanConfigEntry;
import immersive_aircraft.config.configEntries.FloatConfigEntry;
import immersive_aircraft.config.configEntries.IntegerConfigEntry;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class ConfigScreen {
    public static Screen getScreen() {
        Config config = Config.getInstance();
        ConfigBuilder builder = ConfigBuilder.create().setTitle((Component)new TranslatableComponent("itemGroup.immersive_aircraft.immersive_aircraft_tab")).setSavingRunnable(config::save);
        ConfigCategory general = builder.getOrCreateCategory((Component)new TranslatableComponent("option.immersive_aircraft.general"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        for (Field field : Config.class.getDeclaredFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                try {
                    String key = "option.immersive_aircraft." + field.getName();
                    if (annotation instanceof IntegerConfigEntry) {
                        IntegerConfigEntry entry = (IntegerConfigEntry)annotation;
                        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((Component)new TranslatableComponent(key), field.getInt(config)).setDefaultValue(entry.value()).setSaveConsumer(v -> {
                            try {
                                field.setInt(config, (int)v);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        }).setMin(entry.min()).setMax(entry.max()).build());
                        continue;
                    }
                    if (annotation instanceof FloatConfigEntry) {
                        FloatConfigEntry entry = (FloatConfigEntry)annotation;
                        general.addEntry((AbstractConfigListEntry)entryBuilder.startFloatField((Component)new TranslatableComponent(key), field.getFloat(config)).setDefaultValue(entry.value()).setSaveConsumer(v -> {
                            try {
                                field.setFloat(config, v.floatValue());
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        }).setMin(entry.min()).setMax(entry.max()).build());
                        continue;
                    }
                    if (!(annotation instanceof BooleanConfigEntry)) continue;
                    BooleanConfigEntry entry = (BooleanConfigEntry)annotation;
                    general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent(key), field.getBoolean(config)).setDefaultValue(entry.value()).setSaveConsumer(v -> {
                        try {
                            field.setBoolean(config, (boolean)v);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    }).build());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return builder.build();
    }
}

