/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.config.Config;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.misc.AircraftProperties;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.item.upgrade.AircraftStat;
import immersive_aircraft.util.Utils;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1160;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_243;

public abstract class AircraftEntity
extends InventoryVehicleEntity {
    private double lastY;
    private static final List<Trail> TRAILS = Collections.emptyList();
    final List<List<class_243>> PASSENGER_POSITIONS = List.of(List.of(new class_243(0.0, 0.0, 0.0)));

    public AircraftEntity(class_1299<? extends AircraftEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public List<Trail> getTrails() {
        return TRAILS;
    }

    public abstract AircraftProperties getProperties();

    @Override
    protected List<List<class_243>> getPassengerPositions() {
        return this.PASSENGER_POSITIONS;
    }

    @Override
    public void method_5773() {
        this.prevRoll = this.roll;
        this.roll = this.field_5952 ? (float)((double)this.roll * 0.9) : -this.pressingInterpolatedX.getSmooth() * this.getProperties().getRollFactor();
        if (Double.isNaN(this.method_18798().field_1352) || Double.isNaN(this.method_18798().field_1351) || Double.isNaN(this.method_18798().field_1350)) {
            this.method_18800(0.0, 0.0, 0.0);
        }
        super.method_5773();
    }

    protected void convertPower(class_243 direction) {
        class_243 velocity = this.method_18798();
        double drag = Math.abs(direction.method_1026(velocity.method_1029()));
        this.method_18799(velocity.method_1029().method_35590(direction, (double)this.getProperties().getLift()).method_1021(velocity.method_1033() * (drag * (double)this.getProperties().getDriftDrag() + (1.0 - (double)this.getProperties().getDriftDrag()))));
    }

    protected float getHorizontalVelocityDelay() {
        return 0.98f;
    }

    protected float getVerticalVelocityDelay() {
        return 0.98f;
    }

    protected float falloffGroundVelocityDecay(float original) {
        float gravity = Math.min(1.0f, Math.max(0.0f, this.getGravity() / -0.04f));
        float upgrade = Math.min(1.0f, this.getTotalUpgrade(AircraftStat.ACCELERATION) * 0.5f);
        return (original * gravity + (1.0f - gravity)) * (1.0f - upgrade) + upgrade;
    }

    protected float getGroundVelocityDecay() {
        return 0.95f;
    }

    protected float getRotationDecay() {
        return 0.98f;
    }

    @Override
    protected void updateVelocity() {
        float decay = 1.0f - 0.015f * this.getTotalUpgrade(AircraftStat.FRICTION);
        float gravity = this.getGravity();
        if (this.field_5957) {
            gravity *= 0.25f;
            decay = 0.9f;
        } else if (this.field_5952) {
            decay = this.method_5782() ? this.getGroundVelocityDecay() : 0.75f;
        }
        class_243 direction = this.getDirection();
        double diff = this.lastY - this.method_23318();
        if (this.lastY != 0.0 && this.getProperties().getGlideFactor() > 0.0f) {
            this.method_18799(this.method_18798().method_1019(direction.method_1021(diff * (double)this.getProperties().getGlideFactor() * (1.0 - Math.abs(direction.method_10214())))));
        }
        this.lastY = this.method_23318();
        this.convertPower(direction);
        class_243 velocity = this.method_18798();
        this.method_18800(velocity.field_1352 * (double)decay * (double)this.getHorizontalVelocityDelay(), velocity.field_1351 * (double)decay * (double)this.getVerticalVelocityDelay() + (double)gravity, velocity.field_1350 * (double)decay * (double)this.getHorizontalVelocityDelay());
        this.pressingInterpolatedX.decay(0.0f, 1.0f - decay * this.getRotationDecay());
        this.pressingInterpolatedZ.decay(0.0f, 1.0f - decay * this.getRotationDecay());
        if (!this.field_5952) {
            class_1160 effect = this.getWindEffect();
            this.method_36457(this.method_36455() + effect.method_4943());
            this.method_36456(this.method_36454() + effect.method_4947());
            float offsetStrength = 0.005f;
            this.method_18799(this.method_18798().method_1031((double)(effect.method_4943() * offsetStrength), 0.0, (double)(effect.method_4947() * offsetStrength)));
        }
    }

    @Override
    public void chill() {
        this.lastY = 0.0;
    }

    public float getWindStrength() {
        float sensitivity = this.getProperties().getWindSensitivity();
        float thundering = this.field_6002.method_8430(0.0f);
        float raining = this.field_6002.method_8478(0.0f);
        float weather = (float)((double)Config.getInstance().windClearWeather + this.method_18798().method_1033() + (double)(thundering * Config.getInstance().windThunderWeather) + (double)(raining * Config.getInstance().windRainWeather));
        return weather * sensitivity;
    }

    public class_1160 getWindEffect() {
        float wind = this.getWindStrength();
        float nx = (float)(Utils.cosNoise((double)this.field_6012 / 20.0 / (double)this.getProperties().getMass()) * (double)wind);
        float nz = (float)(Utils.cosNoise((double)this.field_6012 / 21.0 / (double)this.getProperties().getMass()) * (double)wind);
        return new class_1160(nx, 0.0f, nz);
    }
}

