/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import immersive_aircraft.Main;
import immersive_aircraft.entity.EngineAircraft;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.screen.VehicleScreenHandler;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class VehicleScreen
extends AbstractContainerScreen<VehicleScreenHandler> {
    private static final ResourceLocation TEXTURE = Main.locate("textures/gui/container/inventory.png");
    public static int titleHeight = 10;
    public static int baseHeight = 86;
    public static int containerSize;

    public VehicleScreen(VehicleScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        containerSize = handler.getVehicle().getInventoryDescription().getHeight();
        this.f_97727_ = baseHeight + containerSize + titleHeight * 2;
        this.f_97731_ = containerSize + titleHeight;
    }

    protected void m_7286_(PoseStack matrices, float delta, int mouseX, int mouseY) {
    }

    protected void drawRectangle(PoseStack matrices, int x, int y, int h, int w) {
        VehicleScreen.m_93133_((PoseStack)matrices, (int)x, (int)y, (float)176.0f, (float)0.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.m_93133_((PoseStack)matrices, (int)(x + w - 16), (int)y, (float)208.0f, (float)0.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.m_93133_((PoseStack)matrices, (int)(x + w - 16), (int)(y + h - 16), (float)208.0f, (float)32.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.m_93133_((PoseStack)matrices, (int)x, (int)(y + h - 16), (float)176.0f, (float)32.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.m_93160_((PoseStack)matrices, (int)(x + 16), (int)y, (int)(w - 32), (int)16, (float)192.0f, (float)0.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.m_93160_((PoseStack)matrices, (int)(x + 16), (int)(y + h - 16), (int)(w - 32), (int)16, (float)192.0f, (float)32.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.m_93160_((PoseStack)matrices, (int)x, (int)(y + 16), (int)16, (int)(h - 32), (float)176.0f, (float)16.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.m_93160_((PoseStack)matrices, (int)(x + w - 16), (int)(y + 16), (int)16, (int)(h - 32), (float)208.0f, (float)16.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.m_93160_((PoseStack)matrices, (int)(x + 16), (int)(y + 16), (int)(w - 32), (int)(h - 32), (float)192.0f, (float)16.0f, (int)16, (int)16, (int)512, (int)256);
    }

    protected void drawCustomBackground(PoseStack matrices) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        VehicleScreen.m_93133_((PoseStack)matrices, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)(containerSize + titleHeight * 2), (int)512, (int)256);
        VehicleScreen.m_93133_((PoseStack)matrices, (int)this.f_97735_, (int)(this.f_97736_ + containerSize + titleHeight * 2 - 4), (float)0.0f, (float)(222 - baseHeight), (int)this.f_97726_, (int)baseHeight, (int)512, (int)256);
        for (VehicleInventoryDescription.Rectangle rectangle : ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventoryDescription().getRectangles()) {
            this.drawRectangle(matrices, this.f_97735_ + rectangle.x(), this.f_97736_ + rectangle.y(), rectangle.w(), rectangle.h());
        }
    }

    private void drawImage(PoseStack matrices, int x, int y, int u, int v, int w, int h) {
        VehicleScreen.m_93133_((PoseStack)matrices, (int)x, (int)y, (float)u, (float)v, (int)w, (int)h, (int)512, (int)256);
    }

    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.drawCustomBackground(matrices);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int titleHeight = 10;
        block11: for (VehicleInventoryDescription.Slot slot : ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventoryDescription().getSlots()) {
            block0 : switch (slot.type) {
                case INVENTORY: {
                    this.drawImage(matrices, this.f_97735_ + slot.x - 1, this.f_97736_ + titleHeight + slot.y - 1, 284, 0, 18, 18);
                    break;
                }
                case BOILER: {
                    EngineAircraft engineAircraft;
                    this.drawImage(matrices, this.f_97735_ + slot.x - 4, this.f_97736_ + titleHeight + slot.y - 18, 318, 0, 24, 39);
                    InventoryVehicleEntity inventoryVehicleEntity = ((VehicleScreenHandler)this.f_97732_).getVehicle();
                    if (!(inventoryVehicleEntity instanceof EngineAircraft) || !((double)(engineAircraft = (EngineAircraft)inventoryVehicleEntity).getFuelUtilization() > 0.0)) continue block11;
                    this.drawImage(matrices, this.f_97735_ + slot.x - 4, this.f_97736_ + titleHeight + slot.y - 18, 348, 0, 24, 39);
                    break;
                }
                default: {
                    if (((VehicleScreenHandler)this.f_97732_).getVehicle().getInventory().m_8020_(slot.index).m_41619_()) {
                        switch (slot.type) {
                            case WEAPON: {
                                this.drawImage(matrices, this.f_97735_ + slot.x - 3, this.f_97736_ + titleHeight + slot.y - 3, 262, 22, 22, 22);
                                break block0;
                            }
                            case UPGRADE: {
                                this.drawImage(matrices, this.f_97735_ + slot.x - 3, this.f_97736_ + titleHeight + slot.y - 3, 262, 44, 22, 22);
                                break block0;
                            }
                            case BANNER: {
                                this.drawImage(matrices, this.f_97735_ + slot.x - 3, this.f_97736_ + titleHeight + slot.y - 3, 262, 66, 22, 22);
                                break block0;
                            }
                            case DYE: {
                                this.drawImage(matrices, this.f_97735_ + slot.x - 3, this.f_97736_ + titleHeight + slot.y - 3, 262, 88, 22, 22);
                                break block0;
                            }
                            case BOOSTER: {
                                this.drawImage(matrices, this.f_97735_ + slot.x - 3, this.f_97736_ + titleHeight + slot.y - 3, 262, 110, 22, 22);
                            }
                        }
                        break;
                    }
                    this.drawImage(matrices, this.f_97735_ + slot.x - 3, this.f_97736_ + titleHeight + slot.y - 3, 262, 0, 22, 22);
                }
            }
        }
        super.m_86412_(matrices, mouseX, mouseY, delta);
        if (this.f_97734_ != null && !this.f_97734_.m_6657_() && this.f_97734_.f_40218_ == ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventory()) {
            VehicleInventoryDescription.Slot slot = ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventoryDescription().getSlots().get(this.f_97734_.m_150661_());
            if (slot.type == VehicleInventoryDescription.SlotType.DYE || slot.type == VehicleInventoryDescription.SlotType.BOOSTER || slot.type == VehicleInventoryDescription.SlotType.BOILER || slot.type == VehicleInventoryDescription.SlotType.UPGRADE || slot.type == VehicleInventoryDescription.SlotType.BANNER || slot.type == VehicleInventoryDescription.SlotType.WEAPON) {
                this.m_169388_(matrices, List.of(Component.m_237115_((String)("immersive_aircraft.slot." + slot.type.name().toLowerCase(Locale.ROOT)))), Optional.empty(), mouseX, mouseY);
            }
        } else {
            this.m_7025_(matrices, mouseX, mouseY);
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
    }

    protected boolean m_7467_(double mouseX, double mouseY, int left, int top, int button) {
        if (super.m_7467_(mouseX, mouseY, left, top, button)) {
            for (VehicleInventoryDescription.Rectangle rectangle : ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventoryDescription().getRectangles()) {
                if (!(mouseX > (double)(rectangle.x() + this.f_97735_)) || !(mouseX < (double)(rectangle.x() + rectangle.w() + this.f_97735_)) || !(mouseY > (double)(rectangle.y() + this.f_97736_)) || !(mouseY < (double)(rectangle.y() + rectangle.h() + this.f_97736_))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

