/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.EngineAircraft;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.entity.misc.AircraftProperties;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public class GyrodyneEntity
extends Rotorcraft {
    private static final float PUSH_SPEED = 0.25f;
    private final AircraftProperties properties = new AircraftProperties(this).setYawSpeed(5.0f).setPitchSpeed(5.0f).setEngineSpeed(0.3f).setVerticalSpeed(0.04f).setDriftDrag(0.01f).setLift(0.1f).setRollFactor(30.0f).setWindSensitivity(0.05f).setMass(4.0f);
    private static final VehicleInventoryDescription inventoryDescription = new VehicleInventoryDescription().addSlot(VehicleInventoryDescription.SlotType.WEAPON, 14, 14).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 36, 14).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 14, 36).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 36, 36).addSlots(VehicleInventoryDescription.SlotType.INVENTORY, 62, 8, 6, 3).build();
    final List<List<Vector3f>> PASSENGER_POSITIONS = List.of(List.of(new Vector3f(0.0f, -0.1f, 0.3f)), List.of(new Vector3f(0.0f, -0.1f, 0.3f), new Vector3f(0.0f, -0.1f, -0.6f)));

    @Override
    public VehicleInventoryDescription getInventoryDescription() {
        return inventoryDescription;
    }

    @Override
    public EngineAircraft.GUI_STYLE getGuiStyle() {
        return EngineAircraft.GUI_STYLE.NONE;
    }

    public GyrodyneEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected SoundEvent getEngineStartSound() {
        return Sounds.WOOSH.get();
    }

    @Override
    protected SoundEvent getEngineSound() {
        return Sounds.WOOSH.get();
    }

    @Override
    protected float getStabilizer() {
        return 0.3f;
    }

    @Override
    public AircraftProperties getProperties() {
        return this.properties;
    }

    @Override
    protected float getGroundVelocityDecay() {
        return this.falloffGroundVelocityDecay(0.8f);
    }

    @Override
    protected float getHorizontalVelocityDelay() {
        return 0.925f;
    }

    @Override
    protected float getVerticalVelocityDelay() {
        return 0.9f;
    }

    @Override
    public Item asItem() {
        return Items.GYRODYNE.get();
    }

    @Override
    protected List<List<Vector3f>> getPassengerPositions() {
        return this.PASSENGER_POSITIONS;
    }

    @Override
    protected float getGravity() {
        return (1.0f - this.getEnginePower()) * super.getGravity();
    }

    private void updateEnginePowerTooltip() {
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)livingEntity;
            if ((double)this.getFuelUtilization() > 0.0) {
                player.m_5661_((Component)Component.m_237110_((String)"immersive_aircraft.gyrodyne_target", (Object[])new Object[]{(int)(this.getEngineTarget() * 100.0f + 0.5f)}), true);
            }
        }
    }

    @Override
    protected String getFuelType() {
        return "fat";
    }

    @Override
    protected boolean isFuelLow() {
        return false;
    }

    @Override
    protected void updateController() {
        super.updateController();
        if (this.getEngineTarget() < 1.0f) {
            LivingEntity livingEntity;
            this.setEngineTarget(Math.max(0.0f, Math.min(1.0f, this.getEngineTarget() + this.pressingInterpolatedZ.getValue() * 0.05f - 0.035f)));
            this.updateEnginePowerTooltip();
            if ((double)this.getEngineTarget() == 1.0 && (livingEntity = this.m_6688_()) instanceof LocalPlayer) {
                LocalPlayer player = (LocalPlayer)livingEntity;
                player.m_5661_((Component)Component.m_237115_((String)"immersive_aircraft.gyrodyne_target_reached"), true);
                if (this.f_19861_) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.25, 0.0));
                }
            }
        }
        float power = this.getEnginePower() * this.properties.getVerticalSpeed() * this.pressingInterpolatedY.getSmooth();
        Vector3f f = this.getTopDirection().mul(power);
        this.m_20256_(this.m_20184_().m_82520_((double)f.x, (double)f.y, (double)f.z));
        Vector3f direction = this.getDirection();
        float sin = Mth.m_14031_((float)(this.m_146909_() * ((float)Math.PI / 180)));
        float thrust = (float)(Math.pow(this.getEnginePower(), 2.0) * (double)this.properties.getEngineSpeed()) * sin;
        if (this.f_19861_ && (double)this.getEngineTarget() < 1.0) {
            thrust = 0.25f / (1.0f + (float)this.m_20184_().m_82553_() * 5.0f) * this.pressingInterpolatedZ.getSmooth() * ((double)this.pressingInterpolatedZ.getSmooth() > 0.0 ? 1.0f : 0.5f) * this.getEnginePower();
        }
        Vector3f f2 = direction.mul(thrust);
        this.m_20256_(this.m_20184_().m_82520_((double)f2.x, (double)f2.y, (double)f2.z));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            float consumption = this.getFuelConsumption() * 0.025f;
            player.m_36324_().m_38703_(consumption);
        }
    }

    @Override
    public float getFuelUtilization() {
        Player player;
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_36324_().m_38702_() > 5) {
            return 1.0f;
        }
        return 0.0f;
    }
}

