/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.network.c2s;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.VehicleEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CollisionMessage
extends Message {
    private final float damage;

    public CollisionMessage(float damage) {
        this.damage = damage;
    }

    public CollisionMessage(FriendlyByteBuf b) {
        this.damage = b.readFloat();
    }

    @Override
    public void encode(FriendlyByteBuf b) {
        b.writeFloat(this.damage);
    }

    @Override
    public void receive(Player e) {
        Entity entity = e.m_20201_();
        if (entity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            vehicle.m_6469_(e.f_19853_.m_269111_().m_268989_(), this.damage);
            if (vehicle.m_213877_()) {
                float crashDamage = this.damage * Config.getInstance().crashDamage;
                if (Config.getInstance().preventKillThroughCrash) {
                    crashDamage = Math.min(crashDamage, e.m_21223_() - 1.0f);
                }
                e.m_6469_(e.f_19853_.m_269111_().m_268989_(), crashDamage);
            }
        }
    }
}

