/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirplaneEntity;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class BiplaneEntity
extends AirplaneEntity {
    private static final VehicleInventoryDescription inventoryDescription = new VehicleInventoryDescription().addSlot(VehicleInventoryDescription.SlotType.BOILER, 17, 30).addSlot(VehicleInventoryDescription.SlotType.BOOSTER, 17, 56).addSlot(VehicleInventoryDescription.SlotType.WEAPON, 50, 14).addSlot(VehicleInventoryDescription.SlotType.BANNER, 72, 14).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 50, 36).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 72, 36).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 50, 58).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 72, 58).addSlots(VehicleInventoryDescription.SlotType.INVENTORY, 98, 8, 4, 4).build();
    final List<List<Vector3f>> PASSENGER_POSITIONS = List.of(List.of(new Vector3f(0.0f, 0.05f, -0.6f)));
    private final List<Trail> trails = List.of(new Trail(40), new Trail(40));

    @Override
    public VehicleInventoryDescription getInventoryDescription() {
        return inventoryDescription;
    }

    public BiplaneEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected float getBaseFuelConsumption() {
        return 1.25f;
    }

    @Override
    protected List<List<Vector3f>> getPassengerPositions() {
        return this.PASSENGER_POSITIONS;
    }

    @Override
    public List<Trail> getTrails() {
        return this.trails;
    }

    private void trail(Matrix4f transform, int index, float x, float y, float z) {
        Vector4f p0 = this.transformPosition(transform, x, y - 0.15f, z);
        Vector4f p1 = this.transformPosition(transform, x, y + 0.15f, z);
        float trailStrength = Math.max(0.0f, Math.min(1.0f, (float)(Math.sqrt(this.m_20184_().m_82553_()) * (double)(0.5f + this.pressingInterpolatedX.getSmooth() * x * 0.025f) - 0.25)));
        this.trails.get(index).add(p0, p1, trailStrength);
    }

    @Override
    public Item asItem() {
        return Items.BIPLANE.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.isWithinParticleRange()) {
                Matrix4f transform = this.getVehicleTransform();
                Matrix3f normalTransform = this.getVehicleNormalTransform();
                this.trail(transform, 0, -3.75f, 0.25f, 0.6f);
                this.trail(transform, 1, 3.75f, 0.25f, 0.6f);
                float power = this.getEnginePower();
                if ((double)power > 0.05) {
                    Vector4f p = this.transformPosition(transform, 0.325f * (this.f_19797_ % 4 == 0 ? -1.0f : 1.0f), 0.5f, 0.8f);
                    Vector3f vel = this.transformVector(normalTransform, 0.2f * (this.f_19797_ % 4 == 0 ? -1.0f : 1.0f), 0.0f, 0.0f);
                    Vec3 velocity = this.m_20184_();
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)p.x, (double)p.y, (double)p.z, (double)vel.x + velocity.f_82479_, (double)vel.y + velocity.f_82480_, (double)vel.z + velocity.f_82481_);
                }
            } else {
                this.trails.get(0).add(ZERO_VEC4, ZERO_VEC4, 0.0f);
                this.trails.get(1).add(ZERO_VEC4, ZERO_VEC4, 0.0f);
            }
        }
    }
}

