/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.misc.SparseSimpleInventory;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.item.UpgradeItem;
import immersive_aircraft.item.upgrade.AircraftStat;
import immersive_aircraft.mixin.ServerPlayerEntityMixin;
import immersive_aircraft.network.s2c.OpenGuiRequest;
import immersive_aircraft.screen.VehicleScreenHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public abstract class InventoryVehicleEntity
extends VehicleEntity
implements class_1265,
class_3908 {
    protected SparseSimpleInventory inventory;
    private static final VehicleInventoryDescription inventoryDescription = new VehicleInventoryDescription().addSlot(VehicleInventoryDescription.SlotType.BOILER, 17, 18).build();
    protected int syncId;

    public VehicleInventoryDescription getInventoryDescription() {
        return inventoryDescription;
    }

    public List<class_1799> getSlots(VehicleInventoryDescription.SlotType slotType) {
        List<VehicleInventoryDescription.Slot> slots = this.getInventoryDescription().getSlots(slotType);
        ArrayList<class_1799> list = new ArrayList<class_1799>(slots.size());
        for (VehicleInventoryDescription.Slot slot : slots) {
            list.add(this.getInventory().method_5438(slot.index));
        }
        return list;
    }

    public float getTotalUpgrade(AircraftStat stat) {
        float value = 1.0f;
        List<class_1799> upgrades = this.getSlots(VehicleInventoryDescription.SlotType.UPGRADE);
        for (int step = 0; step < 2; ++step) {
            for (class_1799 stack : upgrades) {
                class_1792 class_17922 = stack.method_7909();
                if (!(class_17922 instanceof UpgradeItem)) continue;
                UpgradeItem upgrade = (UpgradeItem)class_17922;
                float u = upgrade.getUpgrade().get(stat);
                if (u > 0.0f && step == 1) {
                    value += u;
                    continue;
                }
                if (!(u < 0.0f) || step != 0) continue;
                value *= u + 1.0f;
            }
        }
        return Math.max(0.0f, value);
    }

    public InventoryVehicleEntity(class_1299<? extends AircraftEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.initInventory();
    }

    protected void initInventory() {
        this.inventory = new SparseSimpleInventory(this.getInventoryDescription().getInventorySize());
        this.inventory.method_5489(this);
    }

    public void method_5453(class_1263 sender) {
    }

    @Override
    protected void drop() {
        super.drop();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.method_5439(); ++i) {
                class_1799 itemStack = this.inventory.method_5438(i);
                if (itemStack.method_7960() || class_1890.method_8221((class_1799)itemStack)) continue;
                this.method_5775(itemStack);
            }
        }
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 playerEntity) {
        return new VehicleScreenHandler(i, playerInventory, this);
    }

    public void openInventory(class_3222 player) {
        this.syncId = (this.syncId + 1) % 100 + 100;
        class_1703 screenHandler = this.createMenu(this.syncId, player.method_31548(), (class_1657)player);
        if (screenHandler != null) {
            NetworkHandler.sendToPlayer(new OpenGuiRequest(this, screenHandler.field_7763), player);
            player.field_7512 = screenHandler;
            ServerPlayerEntityMixin playerAccessor = (ServerPlayerEntityMixin)player;
            screenHandler.method_34248(playerAccessor.getScreenHandlerSyncHandler());
        }
    }

    @Override
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!player.method_37908().field_9236 && player.method_21823()) {
            class_1297 primaryPassenger = this.method_31483();
            if (primaryPassenger != null) {
                primaryPassenger.method_5848();
            } else {
                this.openInventory((class_3222)player);
            }
            return class_1269.field_21466;
        }
        return super.method_5688(player, hand);
    }

    public void method_5651(class_2487 nbt) {
        super.method_5651(nbt);
        class_2499 nbtList = nbt.method_10554("Inventory", 10);
        this.inventory.readNbt(nbtList);
    }

    public class_2487 method_5647(class_2487 nbt) {
        super.method_5647(nbt);
        nbt.method_10566("Inventory", (class_2520)this.inventory.writeNbt(new class_2499()));
        return nbt;
    }

    public class_1277 getInventory() {
        return this.inventory;
    }

    @Override
    public void boost() {
        super.boost();
        this.getSlots(VehicleInventoryDescription.SlotType.BOOSTER).forEach(s -> s.method_7934(1));
    }

    @Override
    protected void applyBoost() {
        super.applyBoost();
        Vector3f direction = this.getDirection();
        float thrust = 0.05f * (float)this.getBoost() / 100.0f;
        this.method_18799(this.method_18798().method_1019(this.toVec3d(direction.mul(thrust))));
        if (this.field_6012 % 2 == 0) {
            class_243 p = this.method_19538();
            class_243 velocity = this.method_18798().method_1020(this.toVec3d(direction));
            this.method_37908().method_8406((class_2394)class_2398.field_11248, p.method_10216(), p.method_10214(), p.method_10215(), velocity.field_1352, velocity.field_1351, velocity.field_1350);
        }
    }

    @Override
    public boolean canBoost() {
        return this.getSlots(VehicleInventoryDescription.SlotType.BOOSTER).stream().anyMatch(v -> !v.method_7960()) && this.getBoost() <= 0;
    }

    @Override
    public void method_5773() {
        this.inventory.tick(this);
        super.method_5773();
    }

    @Override
    protected float getDurability() {
        return super.getDurability() * this.getTotalUpgrade(AircraftStat.DURABILITY);
    }
}

