/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.screen;

import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.item.UpgradeItem;
import immersive_aircraft.item.WeaponItem;
import immersive_aircraft.screen.slot.FuelSlot;
import immersive_aircraft.screen.slot.TypedSlot;
import immersive_aircraft.screen.slot.UpgradeSlot;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1746;
import net.minecraft.class_1769;
import net.minecraft.class_1781;
import net.minecraft.class_1799;

public class VehicleScreenHandler
extends class_1703 {
    private final class_1263 inventory;
    private final InventoryVehicleEntity vehicle;

    public VehicleScreenHandler(int syncId, class_1661 playerInventory, InventoryVehicleEntity vehicle) {
        super(null, syncId);
        this.vehicle = vehicle;
        this.inventory = vehicle.getInventory();
        this.inventory.method_5435(playerInventory.field_7546);
        int titleHeight = 10;
        for (VehicleInventoryDescription.Slot slot : this.vehicle.getInventoryDescription().getSlots()) {
            if (slot.type == VehicleInventoryDescription.SlotType.BOILER) {
                this.method_7621(new FuelSlot(this.inventory, slot.index, slot.x, slot.y + titleHeight));
                continue;
            }
            if (slot.type == VehicleInventoryDescription.SlotType.WEAPON) {
                this.method_7621(new TypedSlot(WeaponItem.class, 1, this.inventory, slot.index, slot.x, slot.y + titleHeight));
                continue;
            }
            if (slot.type == VehicleInventoryDescription.SlotType.UPGRADE) {
                this.method_7621(new UpgradeSlot(vehicle, UpgradeItem.class, 1, this.inventory, slot.index, slot.x, slot.y + titleHeight));
                continue;
            }
            if (slot.type == VehicleInventoryDescription.SlotType.BOOSTER) {
                this.method_7621(new TypedSlot(class_1781.class, 64, this.inventory, slot.index, slot.x, slot.y + titleHeight));
                continue;
            }
            if (slot.type == VehicleInventoryDescription.SlotType.BANNER) {
                this.method_7621(new TypedSlot(class_1746.class, 1, this.inventory, slot.index, slot.x, slot.y + titleHeight));
                continue;
            }
            if (slot.type == VehicleInventoryDescription.SlotType.DYE) {
                this.method_7621(new TypedSlot(class_1769.class, 1, this.inventory, slot.index, slot.x, slot.y + titleHeight));
                continue;
            }
            this.method_7621(new class_1735(this.inventory, slot.index, slot.x, slot.y + titleHeight));
        }
        int h = this.vehicle.getInventoryDescription().getHeight() + titleHeight * 2;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)playerInventory, x + y * 9 + 9, 8 + x * 18, h + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.method_7621(new class_1735((class_1263)playerInventory, x, 8 + x * 18, h + 58));
        }
    }

    public boolean method_7597(class_1657 player) {
        return this.vehicle.getInventory() == this.inventory && this.inventory.method_5443(player) && this.vehicle.method_5805() && this.vehicle.method_5739((class_1297)player) < 8.0f;
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            if (index < this.inventory.method_5439() ? !this.method_7616(originalStack, this.inventory.method_5439(), this.field_7761.size(), true) : !this.method_7616(originalStack, 0, this.inventory.method_5439(), false)) {
                return class_1799.field_8037;
            }
            if (originalStack.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return newStack;
    }

    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean unused) {
        class_1799 target;
        class_1735 slot;
        int i;
        boolean inserted = false;
        if (stack.method_7946()) {
            for (i = startIndex; !stack.method_7960() && i < endIndex; ++i) {
                int maxCount;
                slot = (class_1735)this.field_7761.get(i);
                target = slot.method_7677();
                if (target.method_7960() || !class_1799.method_31577((class_1799)stack, (class_1799)target)) continue;
                int diff = target.method_7947() + stack.method_7947();
                if (diff <= (maxCount = slot.method_7676(stack))) {
                    stack.method_7939(0);
                    target.method_7939(diff);
                    slot.method_7668();
                    inserted = true;
                    continue;
                }
                if (target.method_7947() >= maxCount) continue;
                stack.method_7934(maxCount - target.method_7947());
                target.method_7939(maxCount);
                slot.method_7668();
                inserted = true;
            }
        }
        if (!stack.method_7960()) {
            for (i = startIndex; i < endIndex; ++i) {
                slot = (class_1735)this.field_7761.get(i);
                target = slot.method_7677();
                int maxCount = slot.method_7676(target);
                if (!target.method_7960() || !slot.method_7680(stack)) continue;
                if (stack.method_7947() > maxCount) {
                    slot.method_48931(stack.method_7971(maxCount));
                } else {
                    slot.method_48931(stack.method_7971(stack.method_7947()));
                }
                slot.method_7668();
                inserted = true;
                break;
            }
        }
        return inserted;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.inventory.method_5432(player);
    }

    public InventoryVehicleEntity getVehicle() {
        return this.vehicle;
    }
}

