/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client;

import com.mojang.blaze3d.systems.RenderSystem;
import immersive_aircraft.Main;
import immersive_aircraft.entity.EngineAircraft;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class OverlayRenderer {
    private static final ResourceLocation TEXTURE = Main.locate("textures/engine.png");
    private static final ResourceLocation TEXTURE2 = Main.locate("textures/power.png");
    private static float bootUp = 0.0f;
    private static float lastTime = 0.0f;

    public static void renderOverlay(GuiGraphics context, float tickDelta) {
        Entity entity;
        Minecraft client = Minecraft.m_91087_();
        if (!client.f_91066_.f_92062_ && client.f_91072_ != null && client.f_91074_ != null && (entity = client.f_91074_.m_20201_()) instanceof EngineAircraft) {
            EngineAircraft aircraft = (EngineAircraft)entity;
            OverlayRenderer.renderAircraftGui(client, context, tickDelta, aircraft);
        }
    }

    private static void renderAircraftGui(Minecraft client, GuiGraphics context, float tickDelta, EngineAircraft aircraft) {
        assert (client.f_91073_ != null);
        if (aircraft.getGuiStyle() == EngineAircraft.GUI_STYLE.ENGINE) {
            int frame;
            float time = (float)(client.f_91073_.m_46467_() % 65536L) + tickDelta;
            float delta = time - lastTime;
            lastTime = time;
            if (aircraft.getEngineTarget() > 0.0f && (double)aircraft.getEnginePower() > 0.001) {
                if (bootUp < 1.0f) {
                    bootUp = Math.min(1.0f, bootUp + delta * 0.2f);
                    frame = (int)(bootUp * 5.0f);
                } else {
                    int FPS = 30;
                    int animation = (int)(aircraft.engineRotation.getSmooth(tickDelta) / 20.0f * (float)FPS);
                    frame = 5 + animation % 6;
                }
            } else if (bootUp > 0.0f) {
                bootUp = Math.max(0.0f, bootUp - delta * 0.1f);
                frame = 10 + (int)((1.0 - (double)bootUp) * 10.0);
            } else {
                frame = 20;
            }
            int powerFrame = (int)((double)((1.0f - aircraft.getEnginePower()) * 10.0f) + 10.5);
            int powerFrameTarget = (int)((double)((1.0f - aircraft.getEngineTarget()) * 10.0f) + 10.5);
            int x = client.m_91268_().m_85445_() / 2;
            int y = client.m_91268_().m_85446_() - 37;
            if (client.f_91072_ != null && !client.f_91072_.m_105288_()) {
                y += 7;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            context.m_280163_(TEXTURE, x - 9, y - 9, (float)(frame % 5 * 18), (float)(Math.floorDiv(frame, 5) * 18), 18, 18, 90, 90);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            context.m_280163_(TEXTURE2, x - 9, y - 9, (float)(powerFrame % 5 * 18), (float)(Math.floorDiv(powerFrame, 5) * 18), 18, 18, 90, 90);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            context.m_280163_(TEXTURE2, x - 9, y - 9, (float)(powerFrameTarget % 5 * 18), (float)(Math.floorDiv(powerFrameTarget, 5) * 18), 18, 18, 90, 90);
        }
    }
}

