/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.screen;

import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.item.UpgradeItem;
import immersive_aircraft.item.WeaponItem;
import immersive_aircraft.screen.slot.FuelSlot;
import immersive_aircraft.screen.slot.TypedSlot;
import immersive_aircraft.screen.slot.UpgradeSlot;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;

public class VehicleScreenHandler
extends AbstractContainerMenu {
    private final Container inventory;
    private final InventoryVehicleEntity vehicle;

    public VehicleScreenHandler(int syncId, Inventory playerInventory, InventoryVehicleEntity vehicle) {
        super(null, syncId);
        this.vehicle = vehicle;
        this.inventory = vehicle.getInventory();
        this.inventory.m_5856_(playerInventory.f_35978_);
        int titleHeight = 10;
        for (VehicleInventoryDescription.Slot slot : this.vehicle.getInventoryDescription().getSlots()) {
            if (slot.type == VehicleInventoryDescription.SlotType.BOILER) {
                this.m_38897_(new FuelSlot(this.inventory, slot.index, slot.x, slot.y + titleHeight));
                continue;
            }
            if (slot.type == VehicleInventoryDescription.SlotType.WEAPON) {
                this.m_38897_(new TypedSlot(WeaponItem.class, 1, this.inventory, slot.index, slot.x, slot.y + titleHeight));
                continue;
            }
            if (slot.type == VehicleInventoryDescription.SlotType.UPGRADE) {
                this.m_38897_(new UpgradeSlot(vehicle, UpgradeItem.class, 1, this.inventory, slot.index, slot.x, slot.y + titleHeight));
                continue;
            }
            if (slot.type == VehicleInventoryDescription.SlotType.BOOSTER) {
                this.m_38897_(new TypedSlot(FireworkRocketItem.class, 64, this.inventory, slot.index, slot.x, slot.y + titleHeight));
                continue;
            }
            if (slot.type == VehicleInventoryDescription.SlotType.BANNER) {
                this.m_38897_(new TypedSlot(BannerItem.class, 1, this.inventory, slot.index, slot.x, slot.y + titleHeight));
                continue;
            }
            if (slot.type == VehicleInventoryDescription.SlotType.DYE) {
                this.m_38897_(new TypedSlot(DyeItem.class, 1, this.inventory, slot.index, slot.x, slot.y + titleHeight));
                continue;
            }
            this.m_38897_(new Slot(this.inventory, slot.index, slot.x, slot.y + titleHeight));
        }
        int h = this.vehicle.getInventoryDescription().getHeight() + titleHeight * 2;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, x + y * 9 + 9, 8 + x * 18, h + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)playerInventory, x, 8 + x * 18, h + 58));
        }
    }

    public boolean m_6875_(Player player) {
        return this.vehicle.getInventory() == this.inventory && this.inventory.m_6542_(player) && this.vehicle.m_6084_() && this.vehicle.m_20270_((Entity)player) < 8.0f;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack originalStack = slot.m_7993_();
            newStack = originalStack.m_41777_();
            if (index < this.inventory.m_6643_() ? !this.m_38903_(originalStack, this.inventory.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(originalStack, 0, this.inventory.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (originalStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return newStack;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean unused) {
        ItemStack target;
        Slot slot;
        int i;
        boolean inserted = false;
        if (stack.m_41753_()) {
            for (i = startIndex; !stack.m_41619_() && i < endIndex; ++i) {
                int maxCount;
                slot = (Slot)this.f_38839_.get(i);
                target = slot.m_7993_();
                if (target.m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)target)) continue;
                int diff = target.m_41613_() + stack.m_41613_();
                if (diff <= (maxCount = slot.m_5866_(stack))) {
                    stack.m_41764_(0);
                    target.m_41764_(diff);
                    slot.m_6654_();
                    inserted = true;
                    continue;
                }
                if (target.m_41613_() >= maxCount) continue;
                stack.m_41774_(maxCount - target.m_41613_());
                target.m_41764_(maxCount);
                slot.m_6654_();
                inserted = true;
            }
        }
        if (!stack.m_41619_()) {
            for (i = startIndex; i < endIndex; ++i) {
                slot = (Slot)this.f_38839_.get(i);
                target = slot.m_7993_();
                int maxCount = slot.m_5866_(target);
                if (!target.m_41619_() || !slot.m_5857_(stack)) continue;
                if (stack.m_41613_() > maxCount) {
                    slot.m_269060_(stack.m_41620_(maxCount));
                } else {
                    slot.m_269060_(stack.m_41620_(stack.m_41613_()));
                }
                slot.m_6654_();
                inserted = true;
                break;
            }
        }
        return inserted;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.inventory.m_5785_(player);
    }

    public InventoryVehicleEntity getVehicle() {
        return this.vehicle;
    }
}

