/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import com.mojang.datafixers.util.Pair;
import immersive_aircraft.Main;
import immersive_aircraft.client.render.entity.renderer.AircraftEntityRenderer;
import immersive_aircraft.client.render.entity.renderer.AirshipEntityRenderer;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirshipEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.util.Utils;
import immersive_aircraft.util.obj.Mesh;
import java.util.List;
import net.minecraft.class_1160;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_4588;
import net.minecraft.class_898;

public class CargoAirshipEntityRenderer<T extends AirshipEntity>
extends AirshipEntityRenderer<T> {
    private static final class_2960 id = Main.locate("objects/cargo_airship.obj");
    private final class_2960 texture = Main.locate("textures/entity/cargo_airship.png");
    private final AircraftEntityRenderer.Model model = new AircraftEntityRenderer.Model().add(new AircraftEntityRenderer.Object(id, "frame")).add(new AircraftEntityRenderer.Object(id, "storage")).add(new AircraftEntityRenderer.Object(id, "banners").setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        List<class_1799> slots = entity.getSlots(VehicleInventoryDescription.SlotType.BANNER);
        int i = 0;
        for (class_1799 slot : slots) {
            if (slot.method_7960() || !(slot.method_7909() instanceof class_1746)) continue;
            List<Pair<class_2582, class_1767>> patterns = Utils.parseBannerItem(slot);
            Mesh mesh = CargoAirshipEntityRenderer.getFaces(id, "banner_" + i++);
            CargoAirshipEntityRenderer.renderBanner(matrixStack, vertexConsumerProvider, light, mesh, true, patterns);
        }
    })).add(new AircraftEntityRenderer.Object(id, "sails").setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        class_2960 identifier = this.getTexture(entity);
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23578((class_2960)identifier));
        class_1799 stack = entity.getSlots(VehicleInventoryDescription.SlotType.DYE).get(0);
        class_1767 color = stack.method_7909() instanceof class_1769 ? ((class_1769)stack.method_7909()).method_7802() : class_1767.field_7952;
        float r = color.method_7787()[0];
        float g = color.method_7787()[1];
        float b = color.method_7787()[2];
        if (entity.isWithinParticleRange() && Config.getInstance().enableAnimatedSails) {
            Mesh mesh = CargoAirshipEntityRenderer.getFaces(id, "sails_animated");
            float time = (float)(entity.field_6002.method_8510() % 24000L) + tickDelta;
            CargoAirshipEntityRenderer.renderSailObject(mesh, matrixStack, vertexConsumer, light, time, r, g, b, 1.0f);
        } else {
            Mesh mesh = CargoAirshipEntityRenderer.getFaces(id, "sails");
            CargoAirshipEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light, r, g, b, 1.0f);
        }
    })).add(new AircraftEntityRenderer.Object(id, "controller").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.method_22904(0.0, -0.125, 0.78125);
        matrixStack.method_22907(class_1160.field_20707.method_23214(-entity.pressingInterpolatedX.getSmooth(tickDelta) * 20.0f));
        matrixStack.method_22907(class_1160.field_20703.method_23214(entity.pressingInterpolatedZ.getSmooth(tickDelta) * 30.0f));
        matrixStack.method_22904(0.0, 0.125, -0.90625);
    })).add(new AircraftEntityRenderer.Object(id, "propeller").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.method_22904(0.0, 0.1875, 0.0);
        matrixStack.method_22907(class_1160.field_20707.method_23214((float)((double)(-entity.engineRotation.getSmooth(tickDelta)) * 100.0)));
        matrixStack.method_22904(0.0, -0.1875, 0.0);
    }).setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        class_2960 identifier = this.getTexture(entity);
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23578((class_2960)identifier));
        Mesh mesh = CargoAirshipEntityRenderer.getFaces(id, "propeller");
        CargoAirshipEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light);
    })).add(new AircraftEntityRenderer.Object(id, "small_propeller_right").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.method_22904(-1.15625, 2.34375, 0.0);
        matrixStack.method_22907(class_1160.field_20707.method_23214((float)((double)entity.engineRotation.getSmooth(tickDelta) * 170.0)));
        matrixStack.method_22904(1.15625, -2.34375, 0.0);
    }).setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        class_2960 identifier = this.getTexture(entity);
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23578((class_2960)identifier));
        Mesh mesh = CargoAirshipEntityRenderer.getFaces(id, "small_propeller_right");
        CargoAirshipEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light);
    })).add(new AircraftEntityRenderer.Object(id, "small_propeller_left").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.method_22904(1.15625, 2.34375, 0.0);
        matrixStack.method_22907(class_1160.field_20707.method_23214((float)((double)entity.engineRotation.getSmooth(tickDelta) * 170.0)));
        matrixStack.method_22904(-1.15625, -2.34375, 0.0);
    }).setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        class_2960 identifier = this.getTexture(entity);
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23578((class_2960)identifier));
        Mesh mesh = CargoAirshipEntityRenderer.getFaces(id, "small_propeller_left");
        CargoAirshipEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light);
    }));

    public CargoAirshipEntityRenderer(class_898 entityRenderDispatcher) {
        super(entityRenderDispatcher);
        this.field_4673 = 0.8f;
    }

    @Override
    public class_2960 getTexture(T entity) {
        return this.texture;
    }

    @Override
    public AircraftEntityRenderer.Model getModel(AircraftEntity entity) {
        return this.model;
    }

    @Override
    public class_1160 getPivot(AircraftEntity entity) {
        return new class_1160(0.0f, 0.2f, 0.0f);
    }
}

