/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.compat.Matrix4f;
import immersive_aircraft.compat.Vec3f;
import immersive_aircraft.compat.Vector4f;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.entity.misc.AircraftProperties;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3414;

public class AirshipEntity
extends Rotorcraft {
    private final AircraftProperties properties = new AircraftProperties(this).setYawSpeed(5.0f).setEngineSpeed(0.02f).setVerticalSpeed(0.025f).setGlideFactor(0.0f).setDriftDrag(0.01f).setLift(0.1f).setRollFactor(5.0f).setWindSensitivity(0.05f).setMass(3.0f);
    private static final VehicleInventoryDescription inventoryDescription = new VehicleInventoryDescription().addSlot(VehicleInventoryDescription.SlotType.BOILER, 17, 44).addSlot(VehicleInventoryDescription.SlotType.WEAPON, 50, 14).addSlot(VehicleInventoryDescription.SlotType.WEAPON, 72, 14).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 50, 36).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 72, 36).addSlot(VehicleInventoryDescription.SlotType.BANNER, 50, 58).addSlot(VehicleInventoryDescription.SlotType.DYE, 72, 58).addSlots(VehicleInventoryDescription.SlotType.INVENTORY, 98, 8, 4, 4).build();
    final List<List<class_243>> PASSENGER_POSITIONS = Arrays.asList(Collections.singletonList(new class_243(0.0, (double)-0.1f, 0.0)), Arrays.asList(new class_243(0.0, (double)-0.1f, (double)0.4f), new class_243(0.0, (double)-0.1f, (double)-0.3f)));
    private final List<Trail> trails = Collections.singletonList(new Trail(15, 0.5f));

    @Override
    public VehicleInventoryDescription getInventoryDescription() {
        return inventoryDescription;
    }

    public AirshipEntity(class_1299<? extends AircraftEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    protected float getEngineReactionSpeed() {
        return 50.0f;
    }

    @Override
    protected class_3414 getEngineSound() {
        return Sounds.PROPELLER_SMALL.get();
    }

    @Override
    public AircraftProperties getProperties() {
        return this.properties;
    }

    @Override
    protected float getGroundVelocityDecay() {
        return 0.5f;
    }

    @Override
    protected float getHorizontalVelocityDelay() {
        return 0.97f;
    }

    @Override
    protected float getVerticalVelocityDelay() {
        return 0.925f;
    }

    @Override
    protected float getStabilizer() {
        return 0.1f;
    }

    @Override
    public class_1792 asItem() {
        return Items.AIRSHIP.get();
    }

    @Override
    public List<Trail> getTrails() {
        return this.trails;
    }

    void trail(Matrix4f transform) {
        this.trail(transform, 0);
    }

    void trail(Matrix4f transform, int index) {
        Vector4f p0 = this.transformPosition(transform, -0.15f, 0.0f, 0.0f);
        Vector4f p1 = this.transformPosition(transform, 0.15f, 0.0f, 0.0f);
        float trailStrength = Math.max(0.0f, Math.min(1.0f, (float)(this.method_18798().method_1033() - (double)0.05f)));
        this.getTrails().get(index).add(p0, p1, trailStrength);
    }

    @Override
    protected List<List<class_243>> getPassengerPositions() {
        return this.PASSENGER_POSITIONS;
    }

    @Override
    protected float getGravity() {
        return this.field_5957 ? 0.04f : (1.0f - this.getEnginePower()) * super.getGravity();
    }

    @Override
    protected void updateController() {
        super.updateController();
        this.setEngineTarget(1.0f);
        this.method_18799(this.method_18798().method_1031(0.0, (double)(this.getEnginePower() * this.properties.getVerticalSpeed() * this.pressingInterpolatedY.getSmooth()), 0.0));
        class_243 direction = this.getDirection();
        float thrust = (float)(Math.pow(this.getEnginePower(), 5.0) * (double)this.properties.getEngineSpeed()) * this.pressingInterpolatedZ.getSmooth();
        this.method_18799(this.method_18798().method_1019(direction.method_1021((double)thrust)));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        float power = this.getEnginePower();
        if (this.field_6002.field_9236) {
            if (this.isWithinParticleRange() && (double)power > 0.01) {
                Matrix4f transform = this.getVehicleTransform();
                this.addTrails(transform);
                if (this.field_6012 % 2 == 0) {
                    Vector4f p = this.transformPosition(transform, (this.field_5974.nextFloat() - 0.5f) * 0.4f, 0.8f, -0.8f);
                    class_243 velocity = this.method_18798();
                    this.field_6002.method_8406((class_2394)class_2398.field_11251, (double)p.getX(), (double)p.getY(), (double)p.getZ(), velocity.field_1352, velocity.field_1351, velocity.field_1350);
                }
            } else {
                this.trails.get(0).add(ZERO_VEC4, ZERO_VEC4, 0.0f);
            }
        }
    }

    protected void addTrails(Matrix4f transform) {
        Matrix4f tr = transform.copy();
        tr.multiplyByTranslation(0.0f, 0.4f, -1.2f);
        tr.multiply(Vec3f.POSITIVE_Z.getDegreesQuaternion(this.engineRotation.getSmooth() * 50.0f));
        this.trail(tr);
    }
}

