/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.compat.Matrix4f;
import immersive_aircraft.compat.Vec3f;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirshipEntity;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1937;

public class CargoAirshipEntity
extends AirshipEntity {
    private static final VehicleInventoryDescription inventoryDescription = new VehicleInventoryDescription().addSlot(VehicleInventoryDescription.SlotType.BOILER, 17, 44).addSlot(VehicleInventoryDescription.SlotType.WEAPON, 50, 14).addSlot(VehicleInventoryDescription.SlotType.WEAPON, 72, 14).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 50, 36).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 72, 36).addSlot(VehicleInventoryDescription.SlotType.BANNER, 50, 58).addSlot(VehicleInventoryDescription.SlotType.DYE, 72, 58).addSlots(VehicleInventoryDescription.SlotType.INVENTORY, 98, 8, 4, 4).addBoxedSlots(VehicleInventoryDescription.SlotType.INVENTORY, -80, 8, 4, 4).addBoxedSlots(VehicleInventoryDescription.SlotType.INVENTORY, 186, 8, 4, 4).addBoxedSlots(VehicleInventoryDescription.SlotType.INVENTORY, -80, 96, 4, 4).addBoxedSlots(VehicleInventoryDescription.SlotType.INVENTORY, 186, 96, 4, 4).build();
    private final List<Trail> trails;

    @Override
    public VehicleInventoryDescription getInventoryDescription() {
        return inventoryDescription;
    }

    public CargoAirshipEntity(class_1299<? extends AircraftEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.getProperties().setMass(8.0f);
        this.getProperties().setEngineSpeed(0.0175f);
        this.getProperties().setVerticalSpeed(0.02f);
        this.trails = new LinkedList<Trail>();
        this.trails.add(new Trail(15, 0.5f));
        this.trails.add(new Trail(11, 0.5f));
        this.trails.add(new Trail(11, 0.5f));
    }

    @Override
    protected float getBaseFuelConsumption() {
        return 1.25f;
    }

    @Override
    public class_1792 asItem() {
        return Items.CARGO_AIRSHIP.get();
    }

    @Override
    public List<Trail> getTrails() {
        return this.trails;
    }

    @Override
    protected void addTrails(Matrix4f transform) {
        Matrix4f tr = transform.copy();
        tr.multiplyByTranslation(0.0f, 0.4f, -1.2f);
        tr.multiply(Vec3f.POSITIVE_Z.getDegreesQuaternion(this.engineRotation.getSmooth() * 50.0f));
        this.trail(tr, 0);
        tr = transform.copy();
        tr.multiplyByTranslation(1.15625f, 2.5f, -1.2f);
        tr.multiply(Vec3f.POSITIVE_Z.getDegreesQuaternion(this.engineRotation.getSmooth() * 65.0f));
        this.trail(tr, 1);
        tr = transform.copy();
        tr.multiplyByTranslation(-1.15625f, 2.5f, -1.2f);
        tr.multiply(Vec3f.POSITIVE_Z.getDegreesQuaternion(-this.engineRotation.getSmooth() * 65.0f));
        this.trail(tr, 2);
    }
}

