/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import com.mojang.datafixers.util.Pair;
import immersive_aircraft.Main;
import immersive_aircraft.client.render.entity.renderer.AircraftEntityRenderer;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirshipEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.util.Utils;
import immersive_aircraft.util.obj.Mesh;
import java.util.List;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_4588;
import net.minecraft.class_5617;
import net.minecraft.class_6880;
import net.minecraft.class_7833;
import org.joml.Vector3f;

public class AirshipEntityRenderer<T extends AirshipEntity>
extends AircraftEntityRenderer<T> {
    private static final class_2960 id = Main.locate("objects/airship.obj");
    private final class_2960 texture = Main.locate("textures/entity/airship.png");
    private final AircraftEntityRenderer.Model model = new AircraftEntityRenderer.Model().add(new AircraftEntityRenderer.Object(id, "frame")).add(new AircraftEntityRenderer.Object(id, "banners").setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        List<class_1799> slots = entity.getSlots(VehicleInventoryDescription.SlotType.BANNER);
        int i = 0;
        for (class_1799 slot : slots) {
            if (slot.method_7960() || !(slot.method_7909() instanceof class_1746)) continue;
            List<Pair<class_6880<class_2582>, class_1767>> patterns = Utils.parseBannerItem(slot);
            Mesh mesh = AirshipEntityRenderer.getFaces(id, "banner_" + i++);
            AirshipEntityRenderer.renderBanner(matrixStack, vertexConsumerProvider, light, mesh, true, patterns);
        }
    })).add(new AircraftEntityRenderer.Object(id, "sails").setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        class_1767 color;
        class_2960 identifier = this.getTexture(entity);
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23578((class_2960)identifier));
        class_1799 stack = entity.getSlots(VehicleInventoryDescription.SlotType.DYE).get(0);
        class_1792 patt3008$temp = stack.method_7909();
        if (patt3008$temp instanceof class_1769) {
            class_1769 item = (class_1769)patt3008$temp;
            color = item.method_7802();
        } else {
            color = class_1767.field_7952;
        }
        float r = color.method_7787()[0];
        float g = color.method_7787()[1];
        float b = color.method_7787()[2];
        if (entity.isWithinParticleRange() && Config.getInstance().enableAnimatedSails) {
            Mesh mesh = AirshipEntityRenderer.getFaces(id, "sails_animated");
            float time = (float)(entity.field_6002.method_8510() % 24000L) + tickDelta;
            AirshipEntityRenderer.renderSailObject(mesh, matrixStack, vertexConsumer, light, time, r, g, b, 1.0f);
        } else {
            Mesh mesh = AirshipEntityRenderer.getFaces(id, "sails");
            AirshipEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light, r, g, b, 1.0f);
        }
    })).add(new AircraftEntityRenderer.Object(id, "controller").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.method_22904(0.0, -0.125, 0.78125);
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(-entity.pressingInterpolatedX.getSmooth(tickDelta) * 20.0f));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(entity.pressingInterpolatedZ.getSmooth(tickDelta) * 30.0f));
        matrixStack.method_22904(0.0, 0.125, -0.90625);
    })).add(new AircraftEntityRenderer.Object(id, "propeller").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.method_46416(0.0f, 0.1875f, 0.0f);
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees((float)((double)(-entity.engineRotation.getSmooth(tickDelta)) * 100.0)));
        matrixStack.method_46416(0.0f, -0.1875f, 0.0f);
    }).setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        class_2960 identifier = this.getTexture(entity);
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23578((class_2960)identifier));
        Mesh mesh = AirshipEntityRenderer.getFaces(id, "propeller");
        AirshipEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light);
    }));

    public AirshipEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.field_4673 = 0.8f;
    }

    public class_2960 getTexture(T AircraftEntity2) {
        return this.texture;
    }

    @Override
    protected AircraftEntityRenderer.Model getModel(AircraftEntity entity) {
        return this.model;
    }

    @Override
    protected Vector3f getPivot(AircraftEntity entity) {
        return new Vector3f(0.0f, 0.2f, 0.0f);
    }
}

