/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import com.mojang.math.Axis;
import immersive_aircraft.Items;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirshipEntity;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CargoAirshipEntity
extends AirshipEntity {
    private static final VehicleInventoryDescription inventoryDescription = new VehicleInventoryDescription().addSlot(VehicleInventoryDescription.SlotType.BOILER, 17, 44).addSlot(VehicleInventoryDescription.SlotType.WEAPON, 50, 14).addSlot(VehicleInventoryDescription.SlotType.WEAPON, 72, 14).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 50, 36).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 72, 36).addSlot(VehicleInventoryDescription.SlotType.BANNER, 50, 58).addSlot(VehicleInventoryDescription.SlotType.DYE, 72, 58).addSlots(VehicleInventoryDescription.SlotType.INVENTORY, 98, 8, 4, 4).addBoxedSlots(VehicleInventoryDescription.SlotType.INVENTORY, -80, 8, 4, 4).addBoxedSlots(VehicleInventoryDescription.SlotType.INVENTORY, 186, 8, 4, 4).addBoxedSlots(VehicleInventoryDescription.SlotType.INVENTORY, -80, 96, 4, 4).addBoxedSlots(VehicleInventoryDescription.SlotType.INVENTORY, 186, 96, 4, 4).build();
    private final List<Trail> trails;

    @Override
    public VehicleInventoryDescription getInventoryDescription() {
        return inventoryDescription;
    }

    public CargoAirshipEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world);
        this.getProperties().setMass(8.0f);
        this.getProperties().setEngineSpeed(0.0175f);
        this.getProperties().setVerticalSpeed(0.02f);
        this.trails = List.of(new Trail(15, 0.5f), new Trail(11, 0.5f), new Trail(11, 0.5f));
    }

    @Override
    protected float getBaseFuelConsumption() {
        return 1.25f;
    }

    @Override
    public Item asItem() {
        return Items.CARGO_AIRSHIP.get();
    }

    @Override
    public List<Trail> getTrails() {
        return this.trails;
    }

    @Override
    protected void addTrails(Matrix4f transform) {
        Matrix4f tr = new Matrix4f((Matrix4fc)transform);
        tr.translate((Vector3fc)new Vector3f(0.0f, 0.4f, -1.2f));
        tr.rotate((Quaternionfc)Axis.f_252403_.m_252977_(this.engineRotation.getSmooth() * 50.0f));
        this.trail(tr, 0);
        tr = new Matrix4f((Matrix4fc)transform);
        tr.translate((Vector3fc)new Vector3f(1.15625f, 2.5f, -1.2f));
        tr.rotate((Quaternionfc)Axis.f_252403_.m_252977_(this.engineRotation.getSmooth() * 65.0f));
        this.trail(tr, 1);
        tr = new Matrix4f((Matrix4fc)transform);
        tr.translate((Vector3fc)new Vector3f(-1.15625f, 2.5f, -1.2f));
        tr.rotate((Quaternionfc)Axis.f_252403_.m_252977_(this.engineRotation.getSmooth() * 65.0f));
        this.trail(tr, 2);
    }
}

