/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import kirderf1.inventoryfree.InventoryFree;
import kirderf1.inventoryfree.PlayerData;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class InventorySlotsCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"inventory_slots").requires(source -> source.func_197034_c(2))).then(InventorySlotsCommand.setAvailable())).then(InventorySlotsCommand.setUnlocked())).then(InventorySlotsCommand.unlock())).then(InventorySlotsCommand.lock())).then(InventorySlotsCommand.clear())).then(InventorySlotsCommand.get()));
    }

    private static LiteralArgumentBuilder<CommandSource> setAvailable() {
        return (LiteralArgumentBuilder)Commands.func_197057_a((String)"set_available").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)36)).executes(context -> InventorySlotsCommand.setUnlockedFor((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"), InventorySlotsCommand.fromAvailable(IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))));
    }

    private static LiteralArgumentBuilder<CommandSource> setUnlocked() {
        return (LiteralArgumentBuilder)Commands.func_197057_a((String)"set_unlocked").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> InventorySlotsCommand.setUnlockedFor((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))));
    }

    private static LiteralArgumentBuilder<CommandSource> unlock() {
        return (LiteralArgumentBuilder)Commands.func_197057_a((String)"unlock").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> InventorySlotsCommand.addUnlockedFor((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))));
    }

    private static LiteralArgumentBuilder<CommandSource> lock() {
        return (LiteralArgumentBuilder)Commands.func_197057_a((String)"lock").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> InventorySlotsCommand.addUnlockedFor((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"), -IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))));
    }

    private static LiteralArgumentBuilder<CommandSource> clear() {
        return (LiteralArgumentBuilder)Commands.func_197057_a((String)"clear").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> InventorySlotsCommand.setUnlockedFor((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"), 0)));
    }

    private static LiteralArgumentBuilder<CommandSource> get() {
        return (LiteralArgumentBuilder)Commands.func_197057_a((String)"get").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> InventorySlotsCommand.getFor((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"target"))));
    }

    private static int fromAvailable(int availableSlots) {
        return availableSlots - (Integer)InventoryFree.CONFIG.availableSlots.get();
    }

    private static int setUnlockedFor(CommandSource source, Collection<ServerPlayerEntity> targets, int unlockedSlots) {
        targets.forEach(player -> PlayerData.setUnlockedSlots(player, unlockedSlots));
        source.func_197030_a((ITextComponent)new StringTextComponent("Set unlocked slots for " + targets.size() + " players"), true);
        return targets.size();
    }

    private static int addUnlockedFor(CommandSource source, Collection<ServerPlayerEntity> targets, int addedSlots) {
        targets.forEach(player -> PlayerData.unlockSlots(player, addedSlots));
        source.func_197030_a((ITextComponent)new StringTextComponent("Changed unlocked slots for " + targets.size() + " players"), true);
        return targets.size();
    }

    private static int getFor(CommandSource source, ServerPlayerEntity target) {
        source.func_197030_a((ITextComponent)new StringTextComponent("Unlocked slots: " + PlayerData.getUnlockedSlots(target)), false);
        source.func_197030_a((ITextComponent)new StringTextComponent("Available slots: " + PlayerData.getAvailableSlots(target)), false);
        return 1;
    }
}

