/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree;

import kirderf1.inventoryfree.InventoryFree;
import kirderf1.inventoryfree.network.PacketHandler;
import kirderf1.inventoryfree.network.UnlockedSlotsPacket;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber
public class PlayerData {
    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        int unlockedSlots = PlayerData.getUnlockedSlots(player);
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UnlockedSlotsPacket(unlockedSlots));
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if (event.isWasDeath() && ((Boolean)InventoryFree.CONFIG.clearUnlockedOnDeath.get()).booleanValue() && PlayerData.getUnlockedSlots((ServerPlayerEntity)event.getPlayer()) != 0) {
            PlayerData.setUnlockedSlots((ServerPlayerEntity)event.getPlayer(), 0);
        }
    }

    public static int getAvailableSlots(ServerPlayerEntity player) {
        return InventoryFree.getAvailableSlots(PlayerData.getUnlockedSlots(player));
    }

    public static int getUnlockedSlots(ServerPlayerEntity player) {
        return PlayerData.getPersistentTag(player).func_74762_e("unlocked_slots");
    }

    public static void unlockSlots(ServerPlayerEntity player, int amount) {
        CompoundNBT nbt = PlayerData.getOrCreatePersistentTag(player);
        nbt.func_74768_a("unlocked_slots", nbt.func_74762_e("unlocked_slots") + amount);
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UnlockedSlotsPacket(nbt.func_74762_e("unlocked_slots")));
    }

    public static void setUnlockedSlots(ServerPlayerEntity player, int unlockedSlots) {
        PlayerData.getOrCreatePersistentTag(player).func_74768_a("unlocked_slots", unlockedSlots);
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UnlockedSlotsPacket(unlockedSlots));
    }

    public static CompoundNBT getPersistentTag(ServerPlayerEntity player) {
        return player.getPersistentData().func_74775_l("PlayerPersisted").func_74775_l("inventory_free");
    }

    public static CompoundNBT getOrCreatePersistentTag(ServerPlayerEntity player) {
        return PlayerData.getOrCreate(PlayerData.getOrCreate(player.getPersistentData(), "PlayerPersisted"), "inventory_free");
    }

    private static CompoundNBT getOrCreate(CompoundNBT nbt, String str) {
        if (!nbt.func_150297_b(str, 10)) {
            nbt.func_218657_a(str, (INBT)new CompoundNBT());
        }
        return nbt.func_74775_l(str);
    }
}

