/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree.client;

import java.util.Objects;
import kirderf1.inventoryfree.SlotBlocker;
import kirderf1.inventoryfree.client.ClientData;
import kirderf1.inventoryfree.client.LockOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="inventory_free", value={Dist.CLIENT})
public class ClientSlotBlocker {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onLogin(ClientPlayerNetworkEvent.LoggedInEvent event) {
        ClientPlayerEntity player = Objects.requireNonNull(event.getPlayer());
        SlotBlocker.insertBlockedSlots((Container)player.field_71069_bz, (PlayerEntity)player, ClientData::getAvailableSlots);
    }

    @SubscribeEvent
    public static void onGuiOpened(GuiOpenEvent event) {
        if (event.getGui() instanceof ContainerScreen) {
            LOGGER.debug("Container screen being opened. Inserting custom inventory slots...");
            ContainerScreen screen = (ContainerScreen)event.getGui();
            SlotBlocker.insertBlockedSlots(screen.func_212873_a_(), (PlayerEntity)Minecraft.func_71410_x().field_71439_g, ClientData::getAvailableSlots);
        }
    }

    @SubscribeEvent
    public static void onGuiInitialized(GuiScreenEvent.InitGuiEvent event) {
        if (event.getGui() instanceof ContainerScreen) {
            event.addWidget((Widget)new LockOverlay((ContainerScreen)event.getGui()));
        }
    }
}

