/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree.client;

import com.mojang.blaze3d.platform.GlStateManager;
import kirderf1.inventoryfree.BlockedSlot;
import kirderf1.inventoryfree.InventoryFree;
import kirderf1.inventoryfree.client.ClientData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="inventory_free", value={Dist.CLIENT})
public class LockOverlay
extends Widget {
    private static final ResourceLocation LOCK = new ResourceLocation("inventory_free", "textures/item/lock.png");
    private final ContainerScreen<?> screen;

    public LockOverlay(ContainerScreen<?> screen) {
        super(0, 0, "");
        this.screen = screen;
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!InventoryFree.appliesTo((PlayerEntity)mc.field_71439_g)) {
            return;
        }
        mc.func_110434_K().func_110577_a(LOCK);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        for (Slot slot : this.screen.func_212873_a_().field_75151_b) {
            if (!(slot instanceof BlockedSlot) || slot.func_111238_b()) continue;
            LockOverlay.blit((int)(this.screen.getGuiLeft() + slot.field_75223_e), (int)(this.screen.getGuiTop() + slot.field_75221_f), (int)this.blitOffset, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
    }

    @SubscribeEvent
    public static void onHotbarOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft mc = Minecraft.func_71410_x();
            if (!InventoryFree.appliesTo((PlayerEntity)mc.field_71439_g) || ClientData.getAvailableSlots() >= 9) {
                return;
            }
            mc.func_110434_K().func_110577_a(LOCK);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            int scaledWidth = mc.field_195558_d.func_198107_o();
            int scaledHeight = mc.field_195558_d.func_198087_p();
            for (Slot slot : mc.field_71439_g.field_71069_bz.field_75151_b) {
                if (slot.getSlotIndex() >= 9 || !(slot instanceof BlockedSlot) || slot.func_111238_b()) continue;
                int x = scaledWidth / 2 - 90 + (slot.getSlotIndex() * 20 + 2);
                int y = scaledHeight - 16 - 3;
                LockOverlay.blit((int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
        }
    }
}

