/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree;

import com.mojang.brigadier.CommandDispatcher;
import kirderf1.inventoryfree.InventorySlotsCommand;
import kirderf1.inventoryfree.network.PacketHandler;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="inventory_free")
public class InventoryFree {
    public static final String MOD_ID = "inventory_free";
    public static final Config CONFIG;
    private static final ForgeConfigSpec configSpec;

    public InventoryFree() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, configSpec);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(InventoryFree::setup);
        MinecraftForge.EVENT_BUS.addListener(InventoryFree::onServerStarting);
    }

    public static void setup(FMLCommonSetupEvent event) {
        PacketHandler.registerPackets();
    }

    public static void onServerStarting(FMLServerStartingEvent event) {
        InventorySlotsCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    public static int getAvailableSlots(int unlockedSlots) {
        return MathHelper.func_76125_a((int)((Integer)InventoryFree.CONFIG.availableSlots.get() + unlockedSlots), (int)1, (int)36);
    }

    public static boolean isSlotToBeBlocked(int index, int availableSlots) {
        return index >= availableSlots && index < 36;
    }

    public static boolean appliesTo(PlayerEntity player) {
        return player != null && !player.func_184812_l_() && !player.func_175149_v();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(x$0 -> new Config((ForgeConfigSpec.Builder)x$0));
        CONFIG = (Config)specPair.getLeft();
        configSpec = (ForgeConfigSpec)specPair.getRight();
    }

    public static class Config {
        public final ForgeConfigSpec.IntValue availableSlots;
        public final ForgeConfigSpec.ConfigValue<String> unlockSlotItem;
        public final ForgeConfigSpec.BooleanValue clearUnlockedOnDeath;

        private Config(ForgeConfigSpec.Builder builder) {
            builder.push("options");
            this.availableSlots = builder.comment("Defines the number of inventory slots that will be available.").defineInRange("availableSlots", 9, 1, 36);
            this.unlockSlotItem = builder.comment("Specifies a registry name for an item that on use would unlock a slot and consume the item, or nothing to not allow any item. Examples: minecraft:rabbit_foot, minecraft:nether_star, minestuck:captcha_card").define("unlockSlotItem", (Object)"");
            this.clearUnlockedOnDeath = builder.comment("Determines if the number of unlocked slots will be cleared on death").define("clearUnlockedOnDeath", false);
            builder.pop();
        }
    }
}

