/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree;

import kirderf1.inventoryfree.InventoryFree;
import kirderf1.inventoryfree.PlayerData;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="inventory_free")
public class InventoryEnforcer {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        if (event.side != LogicalSide.SERVER || event.phase != TickEvent.Phase.START) {
            return;
        }
        if (InventoryFree.appliesTo(event.player)) {
            PlayerInventory inventory = event.player.field_71071_by;
            int availableSlots = PlayerData.getAvailableSlots((ServerPlayerEntity)event.player);
            int counter = 0;
            for (int index = 0; index < inventory.func_70302_i_(); ++index) {
                if (!InventoryEnforcer.enforceSlot(index, inventory, availableSlots)) continue;
                ++counter;
            }
            if (counter > 0) {
                LOGGER.info("Player \"{}\" had {} item stacks in invalid places this tick.", (Object)event.player.func_145748_c_().getString(), (Object)counter);
            }
        }
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        if (InventoryFree.appliesTo(event.getPlayer()) && !InventoryEnforcer.canStoreItem(event.getPlayer().field_71071_by, event.getItem().func_92059_d(), PlayerData.getAvailableSlots((ServerPlayerEntity)event.getPlayer()))) {
            event.setCanceled(true);
        }
    }

    private static boolean enforceSlot(int index, PlayerInventory inventory, int availableSlots) {
        ItemStack stack = inventory.func_70301_a(index);
        if (InventoryFree.isSlotToBeBlocked(index, availableSlots) && !stack.func_190926_b()) {
            int freeIndex = InventoryEnforcer.findAvailableSlot(inventory, availableSlots);
            inventory.func_70304_b(index);
            if (freeIndex < 0) {
                inventory.field_70458_d.func_146097_a(stack, true, false);
            } else {
                inventory.func_70299_a(freeIndex, stack);
            }
            return true;
        }
        return false;
    }

    private static boolean canStoreItem(PlayerInventory inventory, ItemStack stack, int availableSlots) {
        if (InventoryEnforcer.findAvailableSlot(inventory, availableSlots) != -1) {
            return true;
        }
        if (stack.func_77951_h()) {
            return false;
        }
        int index = inventory.func_70432_d(stack);
        return index >= 0 && !InventoryFree.isSlotToBeBlocked(index, availableSlots);
    }

    private static int findAvailableSlot(PlayerInventory inventory, int availableSlots) {
        for (int index = 0; index < inventory.field_70462_a.size(); ++index) {
            if (InventoryFree.isSlotToBeBlocked(index, availableSlots) || !inventory.func_70301_a(index).func_190926_b()) continue;
            return index;
        }
        return -1;
    }
}

