/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree;

import java.util.List;
import java.util.function.Supplier;
import kirderf1.inventoryfree.BlockedSlot;
import kirderf1.inventoryfree.InventoryFree;
import kirderf1.inventoryfree.PlayerData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="inventory_free")
public class SlotBlocker {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onContainerOpened(PlayerContainerEvent.Open event) {
        LOGGER.debug("Container being opened. Inserting custom inventory slots...");
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        SlotBlocker.insertBlockedSlots(event.getContainer(), (PlayerEntity)player, () -> PlayerData.getAvailableSlots(player));
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        LOGGER.debug("Player logged in. Inserting custom inventory slots into the inventory container...");
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        SlotBlocker.insertBlockedSlots((Container)player.field_71069_bz, (PlayerEntity)player, () -> PlayerData.getAvailableSlots(player));
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        LOGGER.debug("Player entity being cloned. Inserting custom inventory slots into the inventory container...");
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        SlotBlocker.insertBlockedSlots((Container)player.field_71069_bz, (PlayerEntity)player, () -> PlayerData.getAvailableSlots(player));
    }

    public static void insertBlockedSlots(Container container, PlayerEntity player, Supplier<Integer> availableSlots) {
        List slots = container.field_75151_b;
        for (int index = 0; index < slots.size(); ++index) {
            Slot slot = (Slot)slots.get(index);
            if (slot instanceof BlockedSlot || !SlotBlocker.shouldReplaceSlot(slot, player.field_71071_by)) continue;
            int finalIndex = slot.getSlotIndex();
            BlockedSlot newSlot = new BlockedSlot(slot, () -> InventoryFree.appliesTo(player) && InventoryFree.isSlotToBeBlocked(finalIndex, (Integer)availableSlots.get()));
            slots.set(index, newSlot);
        }
    }

    private static boolean shouldReplaceSlot(Slot slot, PlayerInventory playerInv) {
        return slot.field_75224_c == playerInv && slot.getSlotIndex() < 36;
    }
}

