/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree;

import kirderf1.inventoryfree.InventoryFree;
import kirderf1.inventoryfree.PlayerData;
import kirderf1.inventoryfree.client.ClientData;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SlotUnlocker {
    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        SlotUnlocker.onItemUsed((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        SlotUnlocker.onItemUsed((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        SlotUnlocker.onItemUsed((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        SlotUnlocker.onItemUsed((PlayerInteractEvent)event);
    }

    private static void onItemUsed(PlayerInteractEvent event) {
        int unlockedSlots;
        ItemStack stack = event.getItemStack();
        int n = unlockedSlots = event.getSide() == LogicalSide.CLIENT ? ClientData.getUnlockedSlots() : PlayerData.getUnlockedSlots((ServerPlayerEntity)event.getPlayer());
        if (SlotUnlocker.shouldUnlockWith(stack, unlockedSlots)) {
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
            stack.func_190918_g(1);
            if (event.getSide() == LogicalSide.SERVER) {
                PlayerData.unlockSlots((ServerPlayerEntity)event.getPlayer(), 1);
            }
        }
    }

    public static boolean shouldUnlockWith(ItemStack stack, int unlockedSlots) {
        return InventoryFree.getAvailableSlots(unlockedSlots) != InventoryFree.getAvailableSlots(unlockedSlots + 1) && new ResourceLocation((String)InventoryFree.CONFIG.unlockSlotItem.get()).equals((Object)stack.func_77973_b().getRegistryName());
    }
}

