/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree.capability;

import java.util.Collection;
import kirderf1.inventoryfree.InventoryFree;
import kirderf1.inventoryfree.PlayerData;
import kirderf1.inventoryfree.capability.ModCapabilities;
import kirderf1.inventoryfree.network.LockedInvSyncPacket;
import kirderf1.inventoryfree.network.PacketHandler;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="inventory_free")
public class LockedInvHandler {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        LockedInvHandler.onLockChange(player);
        if (((Boolean)InventoryFree.CONFIG.dropItemsInLockedSlots.get()).booleanValue()) {
            LockedInvHandler.dropLockedInvItems(player);
        }
        LockedInvHandler.sendLockedInv(player);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof ServerPlayerEntity && !entity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            player.getCapability(ModCapabilities.LOCKED_INV_CAPABILITY).ifPresent(lockedInv -> {
                Collection oldCapture = player.captureDrops(event.getDrops());
                lockedInv.getAndClearStacks().forEach(stack -> {
                    if (!stack.func_190926_b() && !EnchantmentHelper.func_190939_c((ItemStack)stack)) {
                        player.func_146097_a(stack, true, false);
                    }
                });
                player.captureDrops(oldCapture);
                LockedInvHandler.sendLockedInv(player);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        LockedInvHandler.copyOverCap(event.getOriginal(), event.getPlayer());
    }

    public static void copyOverCap(PlayerEntity oldPlayer, PlayerEntity newPlayer) {
        oldPlayer.getCapability(ModCapabilities.LOCKED_INV_CAPABILITY).ifPresent(oldInv -> newPlayer.getCapability(ModCapabilities.LOCKED_INV_CAPABILITY).ifPresent(newInv -> {
            INBT nbt = ModCapabilities.LOCKED_INV_CAPABILITY.writeNBT(oldInv, null);
            ModCapabilities.LOCKED_INV_CAPABILITY.readNBT(newInv, null, nbt);
        }));
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        LockedInvHandler.sendLockedInv((ServerPlayerEntity)event.getPlayer());
    }

    @SubscribeEvent
    public static void onGamemodeChange(PlayerEvent.PlayerChangeGameModeEvent event) {
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        LockedInvHandler.onLockChange(player, PlayerData.getAvailableSlots(player, event.getNewGameMode()));
    }

    public static void onConfigReload(MinecraftServer server) {
        for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
            LockedInvHandler.onLockChange(player);
        }
        if (((Boolean)InventoryFree.CONFIG.dropItemsInLockedSlots.get()).booleanValue()) {
            for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
                LockedInvHandler.dropLockedInvItems(player);
            }
        }
    }

    public static void onLockChange(ServerPlayerEntity player) {
        LockedInvHandler.onLockChange(player, PlayerData.getAvailableSlots(player));
    }

    public static void onLockChange(ServerPlayerEntity player, int slots) {
        int prevSlots = LockedInvHandler.getPrevAvailableSlots(player);
        if (slots != prevSlots) {
            if (slots > prevSlots) {
                LockedInvHandler.onUnlockSlot(player, prevSlots, slots - 1);
            }
            if (slots < prevSlots && !((Boolean)InventoryFree.CONFIG.dropItemsInLockedSlots.get()).booleanValue()) {
                LockedInvHandler.onLockSlot(player, slots, prevSlots - 1);
            }
            PlayerData.getOrCreatePersistentTag(player).func_74768_a("slot_cache", slots);
        }
    }

    private static int getPrevAvailableSlots(ServerPlayerEntity player) {
        CompoundNBT nbt = PlayerData.getPersistentTag(player);
        return nbt.func_150297_b("slot_cache", 99) ? MathHelper.func_76125_a((int)nbt.func_74762_e("slot_cache"), (int)0, (int)36) : 36;
    }

    private static void onLockSlot(ServerPlayerEntity player, int slotMin, int slotMax) {
        player.getCapability(ModCapabilities.LOCKED_INV_CAPABILITY).ifPresent(lockedInv -> {
            boolean changed = false;
            for (int slot = slotMin; slot <= slotMax; ++slot) {
                if (!lockedInv.getStack(slot).func_190926_b()) continue;
                ItemStack stack = player.field_71071_by.func_70304_b(slot);
                lockedInv.putStack(slot, stack);
                changed |= !stack.func_190926_b();
            }
            if (changed) {
                LockedInvHandler.sendLockedInv(player);
            }
        });
    }

    private static void onUnlockSlot(ServerPlayerEntity player, int slotMin, int slotMax) {
        player.getCapability(ModCapabilities.LOCKED_INV_CAPABILITY).ifPresent(lockedInv -> {
            boolean changed = false;
            for (int slot = slotMin; slot <= slotMax; ++slot) {
                ItemStack stack = lockedInv.takeStack(slot);
                if (stack.func_190926_b()) continue;
                if (player.field_71071_by.func_70301_a(slot).func_190926_b()) {
                    player.field_71071_by.func_70299_a(slot, stack);
                } else {
                    player.func_146097_a(stack, true, false);
                }
                changed = true;
            }
            if (changed) {
                LockedInvHandler.sendLockedInv(player);
            }
        });
    }

    private static void dropLockedInvItems(ServerPlayerEntity player) {
        player.getCapability(ModCapabilities.LOCKED_INV_CAPABILITY).ifPresent(lockedInv -> {
            boolean changed = false;
            for (ItemStack stack : lockedInv.getAndClearStacks()) {
                player.func_146097_a(stack, true, false);
                changed = true;
            }
            if (changed) {
                LockedInvHandler.sendLockedInv(player);
            }
        });
    }

    public static void sendLockedInv(ServerPlayerEntity player) {
        player.getCapability(ModCapabilities.LOCKED_INV_CAPABILITY).ifPresent(lockedInv -> PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)LockedInvSyncPacket.makePacket(lockedInv)));
    }
}

