/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree.capability;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kirderf1.inventoryfree.capability.ILockedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.ItemStackHandler;

public class LockedInventory
implements ILockedInventory {
    private final ItemStackHandler handler = new ItemStackHandler(36);

    @Override
    @Nonnull
    public ItemStack getStack(int slot) {
        return this.handler.getStackInSlot(slot);
    }

    @Override
    @Nonnull
    public ItemStack takeStack(int slot) {
        ItemStack stack = this.handler.getStackInSlot(slot).func_77946_l();
        if (!stack.func_190926_b()) {
            this.handler.setStackInSlot(slot, ItemStack.field_190927_a);
        }
        return stack;
    }

    @Override
    public void putStack(int slot, ItemStack stack) {
        this.handler.setStackInSlot(slot, stack.func_77946_l());
    }

    @Override
    public List<ItemStack> getAndClearStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(this.handler.getSlots());
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            ItemStack stack = this.takeStack(i);
            if (stack.func_190926_b()) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    static class Storage
    implements Capability.IStorage<ILockedInventory> {
        Storage() {
        }

        @Nullable
        public INBT writeNBT(Capability<ILockedInventory> capability, ILockedInventory instance, Direction side) {
            ListNBT list = new ListNBT();
            for (int i = 0; i < 36; ++i) {
                ItemStack stack = instance.getStack(i);
                if (stack.func_190926_b()) continue;
                CompoundNBT itemTag = new CompoundNBT();
                itemTag.func_74768_a("Slot", i);
                stack.func_77955_b(itemTag);
                list.add((Object)itemTag);
            }
            return list;
        }

        public void readNBT(Capability<ILockedInventory> capability, ILockedInventory instance, Direction side, INBT nbt) {
            instance.getAndClearStacks();
            if (nbt instanceof ListNBT) {
                ListNBT list = (ListNBT)nbt;
                for (int i = 0; i < list.size(); ++i) {
                    CompoundNBT itemTag = list.func_150305_b(i);
                    int slot = itemTag.func_74762_e("Slot");
                    if (slot < 0 || slot >= 36) continue;
                    instance.putStack(slot, ItemStack.func_199557_a((CompoundNBT)itemTag));
                }
            } else {
                throw new IllegalArgumentException("Expected a ListNBT, but got " + nbt.getClass());
            }
        }
    }
}

