/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kirderf1.inventoryfree.capability.ILockedInventory;
import kirderf1.inventoryfree.capability.LockedInventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="inventory_free")
public class ModCapabilities {
    private static final ResourceLocation LOCKED_INV_NAME = new ResourceLocation("inventory_free", "locked_inv");
    @CapabilityInject(value=ILockedInventory.class)
    public static Capability<ILockedInventory> LOCKED_INV_CAPABILITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(ILockedInventory.class, (Capability.IStorage)new LockedInventory.Storage(), LockedInventory::new);
    }

    @SubscribeEvent
    public static void attachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            LockedInvProvider provider = new LockedInvProvider();
            event.addCapability(LOCKED_INV_NAME, (ICapabilityProvider)provider);
            event.addListener(() -> ((LazyOptional)provider.optional).invalidate());
        }
    }

    private static class LockedInvProvider
    implements ICapabilitySerializable<ListNBT> {
        private final ILockedInventory lockedInv = new LockedInventory();
        private final LazyOptional<ILockedInventory> optional = LazyOptional.of(() -> this.lockedInv);

        private LockedInvProvider() {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == LOCKED_INV_CAPABILITY) {
                return this.optional.cast();
            }
            return LazyOptional.empty();
        }

        public ListNBT serializeNBT() {
            return (ListNBT)LOCKED_INV_CAPABILITY.writeNBT((Object)this.lockedInv, null);
        }

        public void deserializeNBT(ListNBT nbt) {
            LOCKED_INV_CAPABILITY.readNBT((Object)this.lockedInv, null, (INBT)nbt);
        }
    }
}

