/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import kirderf1.inventoryfree.BlockedSlot;
import kirderf1.inventoryfree.InventoryFree;
import kirderf1.inventoryfree.capability.ILockedInventory;
import kirderf1.inventoryfree.capability.ModCapabilities;
import kirderf1.inventoryfree.client.ClientData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="inventory_free", value={Dist.CLIENT})
public class LockOverlay
extends Widget {
    private static final ResourceLocation LOCK = new ResourceLocation("inventory_free", "textures/item/lock.png");
    private static final int LOCK_BLIT = 200;
    private final ContainerScreen<?> screen;
    private static LazyOptional<ILockedInventory> cachedLockedInv = LazyOptional.empty();

    public LockOverlay(ContainerScreen<?> screen) {
        super(0, 0, 0, 0, StringTextComponent.field_240750_d_);
        this.screen = screen;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!InventoryFree.appliesTo((PlayerEntity)mc.field_71439_g)) {
            return;
        }
        RenderSystem.enableDepthTest();
        LockOverlay.getCachedLockedInv(mc).ifPresent(lockedInv -> {
            for (Slot slot : this.screen.func_212873_a_().field_75151_b) {
                if (!(slot instanceof BlockedSlot) || slot.func_111238_b()) continue;
                LockOverlay.drawItem(lockedInv.getStack(slot.getSlotIndex()), mc, this.screen.getGuiLeft() + slot.field_75223_e, this.screen.getGuiTop() + slot.field_75221_f);
            }
        });
        mc.func_110434_K().func_110577_a(LOCK);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
        for (Slot slot : this.screen.func_212873_a_().field_75151_b) {
            if (!(slot instanceof BlockedSlot) || slot.func_111238_b()) continue;
            LockOverlay.func_238464_a_((MatrixStack)matrixStack, (int)(this.screen.getGuiLeft() + slot.field_75223_e), (int)(this.screen.getGuiTop() + slot.field_75221_f), (int)(this.func_230927_p_() + 200), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
    }

    @SubscribeEvent
    public static void onHotbarOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft mc = Minecraft.func_71410_x();
            if (!InventoryFree.appliesTo((PlayerEntity)mc.field_71439_g) || ClientData.getAvailableSlots() >= 9) {
                return;
            }
            int scaledWidth = mc.func_228018_at_().func_198107_o();
            int scaledHeight = mc.func_228018_at_().func_198087_p();
            RenderSystem.enableDepthTest();
            LockOverlay.getCachedLockedInv(mc).ifPresent(lockedInv -> {
                for (Slot slot : mc.field_71439_g.field_71069_bz.field_75151_b) {
                    if (slot.getSlotIndex() >= 9 || !(slot instanceof BlockedSlot) || slot.func_111238_b()) continue;
                    int x = scaledWidth / 2 - 90 + (slot.getSlotIndex() * 20 + 2);
                    int y = scaledHeight - 16 - 3;
                    LockOverlay.drawItem(lockedInv.getStack(slot.getSlotIndex()), mc, x, y);
                }
            });
            mc.func_110434_K().func_110577_a(LOCK);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            for (Slot slot : mc.field_71439_g.field_71069_bz.field_75151_b) {
                if (slot.getSlotIndex() >= 9 || !(slot instanceof BlockedSlot) || slot.func_111238_b()) continue;
                int x = scaledWidth / 2 - 90 + (slot.getSlotIndex() * 20 + 2);
                int y = scaledHeight - 16 - 3;
                LockOverlay.func_238464_a_((MatrixStack)event.getMatrixStack(), (int)x, (int)y, (int)200, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
        }
    }

    private static void drawItem(ItemStack stack, Minecraft mc, int x, int y) {
        if (!stack.func_190926_b()) {
            FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
            if (font == null) {
                font = mc.field_71466_p;
            }
            mc.func_175599_af().func_180450_b(stack, x, y);
            mc.func_175599_af().func_180453_a(font, stack, x, y, null);
        }
    }

    private static LazyOptional<ILockedInventory> getCachedLockedInv(Minecraft mc) {
        if (!cachedLockedInv.isPresent()) {
            cachedLockedInv = mc.field_71439_g.getCapability(ModCapabilities.LOCKED_INV_CAPABILITY);
            cachedLockedInv.addListener(self -> {
                cachedLockedInv = LazyOptional.empty();
            });
        }
        return cachedLockedInv;
    }

    @SubscribeEvent
    public static void onClientRespawn(ClientPlayerNetworkEvent.RespawnEvent event) {
        cachedLockedInv = LazyOptional.empty();
    }

    @SubscribeEvent
    public static void onLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        cachedLockedInv = LazyOptional.empty();
    }
}

