/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree.network;

import kirderf1.inventoryfree.capability.ILockedInventory;
import kirderf1.inventoryfree.capability.ModCapabilities;
import kirderf1.inventoryfree.client.ClientCapabilityHandler;
import kirderf1.inventoryfree.network.Packet;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LockedInvSyncPacket
implements Packet.ToClient {
    private static final Logger LOGGER = LogManager.getLogger();
    private final INBT nbt;

    public static LockedInvSyncPacket makePacket(ILockedInventory lockedInv) {
        return new LockedInvSyncPacket(ModCapabilities.LOCKED_INV_CAPABILITY.writeNBT((Object)lockedInv, null));
    }

    private LockedInvSyncPacket(INBT nbt) {
        this.nbt = nbt;
    }

    public static LockedInvSyncPacket decode(PacketBuffer buffer) {
        CompoundNBT compound = buffer.func_150793_b();
        return new LockedInvSyncPacket(compound != null ? compound.func_74781_a("nbt") : null);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("nbt", this.nbt);
        buffer.func_150786_a(compound);
    }

    @Override
    public void execute() {
        if (this.nbt != null) {
            ClientCapabilityHandler.handleLockedInvPacket(this);
        } else {
            LOGGER.warn("InventoryFree got sync packet with invalid data");
        }
    }

    public INBT getNbt() {
        return this.nbt;
    }
}

