/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree;

import com.mojang.brigadier.CommandDispatcher;
import kirderf1.inventoryfree.InventorySlotsCommand;
import kirderf1.inventoryfree.capability.LockedInvHandler;
import kirderf1.inventoryfree.capability.ModCapabilities;
import kirderf1.inventoryfree.network.PacketHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="inventory_free")
public class InventoryFree {
    public static final String MOD_ID = "inventory_free";
    public static final Config CONFIG;
    private static final ForgeConfigSpec configSpec;

    public InventoryFree() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)configSpec);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(InventoryFree::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(InventoryFree::onConfigReload);
        MinecraftForge.EVENT_BUS.addListener(InventoryFree::onRegisterCommands);
    }

    public static void setup(FMLCommonSetupEvent event) {
        PacketHandler.registerPackets();
        ModCapabilities.register();
    }

    public static void onConfigReload(ModConfigEvent.Reloading event) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.m_18707_(() -> LockedInvHandler.onConfigReload(server));
        }
    }

    public static void onRegisterCommands(RegisterCommandsEvent event) {
        InventorySlotsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static int getAvailableSlots(int unlockedSlots) {
        return Mth.m_14045_((int)((Integer)InventoryFree.CONFIG.availableSlots.get() + unlockedSlots), (int)1, (int)36);
    }

    public static boolean isSlotToBeBlocked(int index, int availableSlots) {
        return index >= availableSlots && index < 36;
    }

    public static boolean appliesTo(Player player) {
        return player != null && !player.m_7500_() && !player.m_5833_();
    }

    public static boolean appliesTo(GameType gameMode) {
        return gameMode.m_46409_();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        CONFIG = (Config)specPair.getLeft();
        configSpec = (ForgeConfigSpec)specPair.getRight();
    }

    public static class Config {
        public final ForgeConfigSpec.IntValue availableSlots;
        public final ForgeConfigSpec.ConfigValue<String> unlockSlotItem;
        public final ForgeConfigSpec.IntValue unlockedLostOnDeath;
        public final ForgeConfigSpec.BooleanValue dropItemsInLockedSlots;

        private Config(ForgeConfigSpec.Builder builder) {
            builder.push("options");
            this.availableSlots = builder.comment("Defines the number of inventory slots that will be available.").defineInRange("availableSlots", 9, 1, 36);
            this.unlockSlotItem = builder.comment("Specifies a registry name for an item that on use would unlock a slot and consume the item, or nothing to not allow any item. Examples: minecraft:rabbit_foot, minecraft:nether_star, minestuck:captcha_card").define("unlockSlotItem", (Object)"");
            this.unlockedLostOnDeath = builder.comment("The number of unlocked slots that are relocked on death. If 0, slots will be unaffected by death. If -1, all unlocked slots will be relocked.").defineInRange("unlockedLostOnDeath", 0, -1, 36);
            this.dropItemsInLockedSlots = builder.comment("If true, items will be dropped when the slot they're in is locked. If false, the items will instead be moved to a locked inventory where they'll stay until the slot is unlocked again.").define("dropItemsInLockedSlots", false);
            builder.pop();
        }
    }
}

