/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree.client;

import java.util.Objects;
import kirderf1.inventoryfree.SlotBlocker;
import kirderf1.inventoryfree.client.ClientData;
import kirderf1.inventoryfree.client.LockOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="inventory_free", value={Dist.CLIENT})
public class ClientSlotBlocker {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onLogin(ClientPlayerNetworkEvent.LoggedInEvent event) {
        LocalPlayer player = Objects.requireNonNull(event.getPlayer());
        SlotBlocker.insertBlockedSlots((AbstractContainerMenu)player.f_36095_, (Player)player, ClientData::getAvailableSlots);
    }

    @SubscribeEvent
    public static void onRespawn(ClientPlayerNetworkEvent.RespawnEvent event) {
        LocalPlayer player = Objects.requireNonNull(event.getPlayer());
        SlotBlocker.insertBlockedSlots((AbstractContainerMenu)player.f_36095_, (Player)player, ClientData::getAvailableSlots);
    }

    @SubscribeEvent
    public static void onGuiOpened(GuiOpenEvent event) {
        Screen screen = event.getGui();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            LOGGER.debug("Container screen being opened. Inserting custom inventory slots...");
            SlotBlocker.insertBlockedSlots(screen2.m_6262_(), (Player)Minecraft.m_91087_().f_91074_, ClientData::getAvailableSlots);
        }
    }

    @SubscribeEvent
    public static void onGuiInitialized(GuiScreenEvent.InitGuiEvent event) {
        Screen screen = event.getGui();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            event.addWidget((GuiEventListener)new LockOverlay(screen2));
        }
    }
}

