/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree.network;

import kirderf1.inventoryfree.capability.ILockedInventory;
import kirderf1.inventoryfree.client.ClientCapabilityHandler;
import kirderf1.inventoryfree.network.Packet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LockedInvSyncPacket
implements Packet.ToClient {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ListTag nbt;

    public static LockedInvSyncPacket makePacket(ILockedInventory lockedInv) {
        return new LockedInvSyncPacket(lockedInv.serializeNBT());
    }

    private LockedInvSyncPacket(ListTag nbt) {
        this.nbt = nbt;
    }

    public static LockedInvSyncPacket decode(FriendlyByteBuf buffer) {
        CompoundTag compound = buffer.m_130260_();
        return new LockedInvSyncPacket(compound != null ? compound.m_128437_("nbt", 10) : null);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("nbt", (Tag)this.nbt);
        buffer.m_130079_(compound);
    }

    @Override
    public void execute() {
        if (this.nbt != null) {
            ClientCapabilityHandler.handleLockedInvPacket(this);
        } else {
            LOGGER.warn("InventoryFree got sync packet with invalid data");
        }
    }

    public ListTag getNbt() {
        return this.nbt;
    }
}

