/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree;

import kirderf1.inventoryfree.InventoryFree;
import kirderf1.inventoryfree.PlayerData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="inventory_free")
public class InventoryEnforcer {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        if (event.side != LogicalSide.SERVER || event.phase != TickEvent.Phase.START) {
            return;
        }
        if (InventoryFree.appliesTo(event.player)) {
            Inventory inventory = event.player.m_150109_();
            int availableSlots = PlayerData.getAvailableSlots((ServerPlayer)event.player);
            int counter = 0;
            for (int index = 0; index < inventory.m_6643_(); ++index) {
                if (!InventoryEnforcer.enforceSlot(index, inventory, availableSlots)) continue;
                ++counter;
            }
            if (counter > 0) {
                LOGGER.info("Player \"{}\" had {} item stacks in invalid places this tick.", (Object)event.player.m_5446_().getString(), (Object)counter);
            }
        }
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        if (InventoryFree.appliesTo(event.getPlayer()) && !InventoryEnforcer.canStoreItem(event.getPlayer().m_150109_(), event.getItem().m_32055_(), PlayerData.getAvailableSlots((ServerPlayer)event.getPlayer()))) {
            event.setCanceled(true);
        }
    }

    private static boolean enforceSlot(int index, Inventory inventory, int availableSlots) {
        ItemStack stack = inventory.m_8020_(index);
        if (InventoryFree.isSlotToBeBlocked(index, availableSlots) && !stack.m_41619_()) {
            int freeIndex = InventoryEnforcer.findAvailableSlot(inventory, availableSlots);
            inventory.m_8016_(index);
            if (freeIndex < 0) {
                inventory.f_35978_.m_7197_(stack, true, false);
            } else {
                inventory.m_6836_(freeIndex, stack);
            }
            return true;
        }
        return false;
    }

    private static boolean canStoreItem(Inventory inventory, ItemStack stack, int availableSlots) {
        if (InventoryEnforcer.findAvailableSlot(inventory, availableSlots) != -1) {
            return true;
        }
        if (stack.m_41768_()) {
            return false;
        }
        int index = inventory.m_36050_(stack);
        return index >= 0 && !InventoryFree.isSlotToBeBlocked(index, availableSlots);
    }

    private static int findAvailableSlot(Inventory inventory, int availableSlots) {
        for (int index = 0; index < inventory.f_35974_.size(); ++index) {
            if (InventoryFree.isSlotToBeBlocked(index, availableSlots) || !inventory.m_8020_(index).m_41619_()) continue;
            return index;
        }
        return -1;
    }
}

