/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree;

import kirderf1.inventoryfree.InventoryFree;
import kirderf1.inventoryfree.capability.LockedInvHandler;
import kirderf1.inventoryfree.network.PacketHandler;
import kirderf1.inventoryfree.network.UnlockedSlotsPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class PlayerData {
    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        int unlockedSlots = PlayerData.getUnlockedSlots(player);
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UnlockedSlotsPacket(unlockedSlots));
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        int unlockedSlots = PlayerData.getUnlockedSlots((ServerPlayer)event.getPlayer());
        if (event.isWasDeath() && (Integer)InventoryFree.CONFIG.unlockedLostOnDeath.get() != 0 && unlockedSlots != 0) {
            if ((Integer)InventoryFree.CONFIG.unlockedLostOnDeath.get() < 0) {
                PlayerData.setUnlockedSlots((ServerPlayer)event.getPlayer(), 0);
            } else {
                PlayerData.setUnlockedSlots((ServerPlayer)event.getPlayer(), Math.min(unlockedSlots, Math.max(0, unlockedSlots - (Integer)InventoryFree.CONFIG.unlockedLostOnDeath.get())));
            }
        }
    }

    public static int getAvailableSlots(ServerPlayer player) {
        if (InventoryFree.appliesTo((Player)player)) {
            return InventoryFree.getAvailableSlots(PlayerData.getUnlockedSlots(player));
        }
        return 36;
    }

    public static int getAvailableSlots(ServerPlayer player, GameType gameMode) {
        if (InventoryFree.appliesTo(gameMode)) {
            return InventoryFree.getAvailableSlots(PlayerData.getUnlockedSlots(player));
        }
        return 36;
    }

    public static int getUnlockedSlots(ServerPlayer player) {
        return PlayerData.getPersistentTag(player).m_128451_("unlocked_slots");
    }

    public static void unlockSlots(ServerPlayer player, int amount) {
        CompoundTag nbt = PlayerData.getOrCreatePersistentTag(player);
        nbt.m_128405_("unlocked_slots", nbt.m_128451_("unlocked_slots") + amount);
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UnlockedSlotsPacket(nbt.m_128451_("unlocked_slots")));
        LockedInvHandler.onLockChange(player);
    }

    public static void setUnlockedSlots(ServerPlayer player, int unlockedSlots) {
        PlayerData.getOrCreatePersistentTag(player).m_128405_("unlocked_slots", unlockedSlots);
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UnlockedSlotsPacket(unlockedSlots));
        LockedInvHandler.onLockChange(player);
    }

    public static CompoundTag getPersistentTag(ServerPlayer player) {
        return player.getPersistentData().m_128469_("PlayerPersisted").m_128469_("inventory_free");
    }

    public static CompoundTag getOrCreatePersistentTag(ServerPlayer player) {
        return PlayerData.getOrCreate(PlayerData.getOrCreate(player.getPersistentData(), "PlayerPersisted"), "inventory_free");
    }

    private static CompoundTag getOrCreate(CompoundTag nbt, String str) {
        if (!nbt.m_128425_(str, 10)) {
            nbt.m_128365_(str, (Tag)new CompoundTag());
        }
        return nbt.m_128469_(str);
    }
}

