/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import kirderf1.inventoryfree.InventoryFree;
import kirderf1.inventoryfree.PlayerData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;

public class InventorySlotsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"inventory_slots").requires(source -> source.m_6761_(2))).then(InventorySlotsCommand.setAvailable())).then(InventorySlotsCommand.setUnlocked())).then(InventorySlotsCommand.unlock())).then(InventorySlotsCommand.lock())).then(InventorySlotsCommand.clear())).then(InventorySlotsCommand.get()));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> setAvailable() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"set_available").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)36)).executes(context -> InventorySlotsCommand.setUnlockedFor((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), InventorySlotsCommand.fromAvailable(IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> setUnlocked() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"set_unlocked").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> InventorySlotsCommand.setUnlockedFor((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> unlock() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"unlock").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> InventorySlotsCommand.addUnlockedFor((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> lock() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"lock").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> InventorySlotsCommand.addUnlockedFor((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), -IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> clear() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(context -> InventorySlotsCommand.setUnlockedFor((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), 0)));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> get() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(context -> InventorySlotsCommand.getFor((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"))));
    }

    private static int fromAvailable(int availableSlots) {
        return availableSlots - (Integer)InventoryFree.CONFIG.availableSlots.get();
    }

    private static int setUnlockedFor(CommandSourceStack source, Collection<ServerPlayer> targets, int unlockedSlots) {
        targets.forEach(player -> PlayerData.setUnlockedSlots(player, unlockedSlots));
        source.m_81354_((Component)new TextComponent("Set unlocked slots for " + targets.size() + " players"), true);
        return targets.size();
    }

    private static int addUnlockedFor(CommandSourceStack source, Collection<ServerPlayer> targets, int addedSlots) {
        targets.forEach(player -> PlayerData.unlockSlots(player, addedSlots));
        source.m_81354_((Component)new TextComponent("Changed unlocked slots for " + targets.size() + " players"), true);
        return targets.size();
    }

    private static int getFor(CommandSourceStack source, ServerPlayer target) {
        source.m_81354_((Component)new TextComponent("Unlocked slots: " + PlayerData.getUnlockedSlots(target)), false);
        source.m_81354_((Component)new TextComponent("Available slots: " + PlayerData.getAvailableSlots(target)), false);
        return 1;
    }
}

