/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree;

import java.util.function.Supplier;
import kirderf1.inventoryfree.BlockedSlot;
import kirderf1.inventoryfree.InventoryFree;
import kirderf1.inventoryfree.PlayerData;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="inventory_free")
public class SlotBlocker {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onContainerOpened(PlayerContainerEvent.Open event) {
        LOGGER.debug("Container being opened. Inserting custom inventory slots...");
        ServerPlayer player = (ServerPlayer)event.getEntity();
        SlotBlocker.insertBlockedSlots(event.getContainer(), (Player)player, () -> PlayerData.getAvailableSlots(player));
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        LOGGER.debug("Player logged in. Inserting custom inventory slots into the inventory container...");
        ServerPlayer player = (ServerPlayer)event.getEntity();
        SlotBlocker.insertBlockedSlots((AbstractContainerMenu)player.f_36095_, (Player)player, () -> PlayerData.getAvailableSlots(player));
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        LOGGER.debug("Player entity being cloned. Inserting custom inventory slots into the inventory container...");
        ServerPlayer player = (ServerPlayer)event.getEntity();
        SlotBlocker.insertBlockedSlots((AbstractContainerMenu)player.f_36095_, (Player)player, () -> PlayerData.getAvailableSlots(player));
    }

    public static void insertBlockedSlots(AbstractContainerMenu menu, Player player, Supplier<Integer> availableSlots) {
        NonNullList slots = menu.f_38839_;
        for (int index = 0; index < slots.size(); ++index) {
            Slot slot = (Slot)slots.get(index);
            if (slot instanceof BlockedSlot || !SlotBlocker.shouldReplaceSlot(slot, player.m_150109_())) continue;
            int finalIndex = slot.getSlotIndex();
            BlockedSlot newSlot = new BlockedSlot(slot, () -> InventoryFree.appliesTo(player) && InventoryFree.isSlotToBeBlocked(finalIndex, (Integer)availableSlots.get()));
            slots.set(index, newSlot);
        }
    }

    private static boolean shouldReplaceSlot(Slot slot, Inventory playerInv) {
        return slot.f_40218_ == playerInv && slot.getSlotIndex() < 36;
    }
}

