/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree;

import kirderf1.inventoryfree.InventoryFree;
import kirderf1.inventoryfree.PlayerData;
import kirderf1.inventoryfree.client.ClientData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class SlotUnlocker {
    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        SlotUnlocker.onItemUsed((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        SlotUnlocker.onItemUsed((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        SlotUnlocker.onItemUsed((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        SlotUnlocker.onItemUsed((PlayerInteractEvent)event);
    }

    private static void onItemUsed(PlayerInteractEvent event) {
        int requiredCount;
        int unlockedSlots;
        ItemStack stack = event.getItemStack();
        int n = unlockedSlots = event.getSide() == LogicalSide.CLIENT ? ClientData.getUnlockedSlots() : PlayerData.getUnlockedSlots((ServerPlayer)event.getEntity());
        if (SlotUnlocker.shouldUnlockWith(stack, unlockedSlots) && (requiredCount = SlotUnlocker.getRequiredItemCount(unlockedSlots)) != -1 && stack.m_41613_() >= requiredCount) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            stack.m_41774_(requiredCount);
            if (event.getSide() == LogicalSide.SERVER) {
                PlayerData.unlockSlots((ServerPlayer)event.getEntity(), 1);
            }
        }
    }

    public static boolean shouldUnlockWith(ItemStack stack, int unlockedSlots) {
        return InventoryFree.getAvailableSlots(unlockedSlots) != InventoryFree.getAvailableSlots(unlockedSlots + 1) && new ResourceLocation((String)InventoryFree.CONFIG.unlockSlotItem.get()).equals((Object)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
    }

    public static int getRequiredItemCount(int unlockedSlots) {
        unlockedSlots = Math.max(0, unlockedSlots);
        return switch ((CostProgression)((Object)InventoryFree.CONFIG.costProgression.get())) {
            default -> throw new IncompatibleClassChangeError();
            case CostProgression.CONSTANT -> 1;
            case CostProgression.LINEAR -> 1 + unlockedSlots;
            case CostProgression.EXPONENTIAL -> unlockedSlots > 6 ? -1 : (int)Math.pow(2.0, unlockedSlots);
        };
    }

    public static enum CostProgression {
        CONSTANT,
        LINEAR,
        EXPONENTIAL;

    }
}

