/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree.capability;

import java.util.Collection;
import kirderf1.inventoryfree.InventoryFree;
import kirderf1.inventoryfree.PlayerData;
import kirderf1.inventoryfree.capability.ModCapabilities;
import kirderf1.inventoryfree.network.LockedInvSyncPacket;
import kirderf1.inventoryfree.network.PacketHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="inventory_free")
public class LockedInvHandler {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        LockedInvHandler.onLockChange(player);
        if (((Boolean)InventoryFree.CONFIG.dropItemsInLockedSlots.get()).booleanValue()) {
            LockedInvHandler.dropLockedInvItems(player);
        }
        LockedInvHandler.sendLockedInv(player);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (!entity.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
                player.getCapability(ModCapabilities.LOCKED_INV_CAPABILITY).ifPresent(lockedInv -> {
                    Collection oldCapture = player.captureDrops(event.getDrops());
                    lockedInv.getAndClearStacks().forEach(stack -> {
                        if (!stack.m_41619_() && !EnchantmentHelper.m_44924_((ItemStack)stack)) {
                            player.m_7197_(stack, true, false);
                        }
                    });
                    player.captureDrops(oldCapture);
                    LockedInvHandler.sendLockedInv(player);
                });
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        LockedInvHandler.copyOverCap(event.getOriginal(), event.getEntity());
    }

    public static void copyOverCap(Player oldPlayer, Player newPlayer) {
        oldPlayer.reviveCaps();
        oldPlayer.getCapability(ModCapabilities.LOCKED_INV_CAPABILITY).ifPresent(oldInv -> newPlayer.getCapability(ModCapabilities.LOCKED_INV_CAPABILITY).ifPresent(newInv -> {
            ListTag nbt = oldInv.serializeNBT();
            newInv.deserializeNBT(nbt);
        }));
        oldPlayer.invalidateCaps();
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        LockedInvHandler.sendLockedInv((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onGameModeChange(PlayerEvent.PlayerChangeGameModeEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        LockedInvHandler.onLockChange(player, PlayerData.getAvailableSlots(player, event.getNewGameMode()));
    }

    public static void onConfigReload(MinecraftServer server) {
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            LockedInvHandler.onLockChange(player);
        }
        if (((Boolean)InventoryFree.CONFIG.dropItemsInLockedSlots.get()).booleanValue()) {
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                LockedInvHandler.dropLockedInvItems(player);
            }
        }
    }

    public static void onLockChange(ServerPlayer player) {
        LockedInvHandler.onLockChange(player, PlayerData.getAvailableSlots(player));
    }

    public static void onLockChange(ServerPlayer player, int slots) {
        int prevSlots = LockedInvHandler.getPrevAvailableSlots(player);
        if (slots != prevSlots) {
            if (slots > prevSlots) {
                LockedInvHandler.onUnlockSlot(player, prevSlots, slots - 1);
            }
            if (slots < prevSlots && !((Boolean)InventoryFree.CONFIG.dropItemsInLockedSlots.get()).booleanValue()) {
                LockedInvHandler.onLockSlot(player, slots, prevSlots - 1);
            }
            PlayerData.getOrCreatePersistentTag(player).m_128405_("slot_cache", slots);
        }
    }

    private static int getPrevAvailableSlots(ServerPlayer player) {
        CompoundTag nbt = PlayerData.getPersistentTag(player);
        return nbt.m_128425_("slot_cache", 99) ? Mth.m_14045_((int)nbt.m_128451_("slot_cache"), (int)0, (int)36) : 36;
    }

    private static void onLockSlot(ServerPlayer player, int slotMin, int slotMax) {
        player.getCapability(ModCapabilities.LOCKED_INV_CAPABILITY).ifPresent(lockedInv -> {
            boolean changed = false;
            for (int slot = slotMin; slot <= slotMax; ++slot) {
                if (!lockedInv.getStack(slot).m_41619_()) continue;
                ItemStack stack = player.m_150109_().m_8016_(slot);
                lockedInv.putStack(slot, stack);
                changed |= !stack.m_41619_();
            }
            if (changed) {
                LockedInvHandler.sendLockedInv(player);
            }
        });
    }

    private static void onUnlockSlot(ServerPlayer player, int slotMin, int slotMax) {
        player.getCapability(ModCapabilities.LOCKED_INV_CAPABILITY).ifPresent(lockedInv -> {
            boolean changed = false;
            for (int slot = slotMin; slot <= slotMax; ++slot) {
                ItemStack stack = lockedInv.takeStack(slot);
                if (stack.m_41619_()) continue;
                if (player.m_150109_().m_8020_(slot).m_41619_()) {
                    player.m_150109_().m_6836_(slot, stack);
                } else {
                    player.m_7197_(stack, true, false);
                }
                changed = true;
            }
            if (changed) {
                LockedInvHandler.sendLockedInv(player);
            }
        });
    }

    private static void dropLockedInvItems(ServerPlayer player) {
        player.getCapability(ModCapabilities.LOCKED_INV_CAPABILITY).ifPresent(lockedInv -> {
            boolean changed = false;
            for (ItemStack stack : lockedInv.getAndClearStacks()) {
                player.m_7197_(stack, true, false);
                changed = true;
            }
            if (changed) {
                LockedInvHandler.sendLockedInv(player);
            }
        });
    }

    public static void sendLockedInv(ServerPlayer player) {
        player.getCapability(ModCapabilities.LOCKED_INV_CAPABILITY).ifPresent(lockedInv -> PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)LockedInvSyncPacket.makePacket(lockedInv)));
    }
}

