/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree;

import java.util.Objects;
import java.util.function.IntUnaryOperator;
import kirderf1.inventoryfree.InventoryFree;
import kirderf1.inventoryfree.PlayerData;
import kirderf1.inventoryfree.client.ClientData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class SlotUnlocker {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        SlotUnlocker.onItemUsed((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        SlotUnlocker.onItemUsed((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        SlotUnlocker.onItemUsed((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        SlotUnlocker.onItemUsed((PlayerInteractEvent)event);
    }

    private static void onItemUsed(PlayerInteractEvent event) {
        int requiredCount;
        int unlockedSlots;
        ItemStack stack = event.getItemStack();
        int n = unlockedSlots = event.getSide() == LogicalSide.CLIENT ? ClientData.getUnlockedSlots() : PlayerData.getUnlockedSlots((ServerPlayer)event.getEntity());
        if (SlotUnlocker.shouldUnlockWith(stack, unlockedSlots) && (requiredCount = SlotUnlocker.getRequiredItemCount(unlockedSlots, stack.m_41741_())) != -1 && stack.m_41613_() >= requiredCount) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            stack.m_41774_(requiredCount);
            if (event.getSide() == LogicalSide.SERVER) {
                PlayerData.unlockSlots((ServerPlayer)event.getEntity(), 1);
            }
        }
    }

    public static boolean shouldUnlockWith(ItemStack stack, int unlockedSlots) {
        return InventoryFree.getAvailableSlots(unlockedSlots) != InventoryFree.getAvailableSlots(unlockedSlots + 1) && ((String)InventoryFree.CONFIG.unlockSlotItem.get()).equals(String.valueOf(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())));
    }

    public static int getRequiredItemCount(int unlockedSlots, int max) {
        int baseCost = ((CostProgression)((Object)InventoryFree.CONFIG.costProgression.get())).costGetter.applyAsInt(unlockedSlots = Math.max(0, unlockedSlots));
        if (baseCost == -1) {
            return -1;
        }
        int cost = baseCost * (Integer)InventoryFree.CONFIG.costMultiplier.get();
        return cost <= max ? cost : -1;
    }

    public static void verifyUnlockItem(ModConfigEvent event) {
        String itemIdStr = (String)InventoryFree.CONFIG.unlockSlotItem.get();
        if (itemIdStr.isEmpty()) {
            return;
        }
        ResourceLocation itemId = ResourceLocation.m_135820_((String)itemIdStr);
        if (itemId == null || !ForgeRegistries.ITEMS.containsKey(itemId)) {
            LOGGER.error("Not a valid id for the unlock item: {}", (Object)itemIdStr);
            return;
        }
        Item item = Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(itemId));
        if (SlotUnlocker.getRequiredItemCount(0, item.m_7968_().m_41741_()) == -1) {
            LOGGER.warn("Unlock item max stack size is lower than the cost to unlock the first slot. It will not be possible to unlock any slots with the item under these circumstances!");
        }
    }

    public static enum CostProgression {
        CONSTANT(unlockedSlots -> 1),
        LINEAR(unlockedSlots -> 1 + unlockedSlots),
        EXPONENTIAL(unlockedSlots -> unlockedSlots > 6 ? -1 : (int)Math.pow(2.0, unlockedSlots));

        private final IntUnaryOperator costGetter;

        private CostProgression(IntUnaryOperator costGetter) {
            this.costGetter = costGetter;
        }
    }
}

