/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import kirderf1.inventoryfree.BlockedSlot;
import kirderf1.inventoryfree.InventoryFree;
import kirderf1.inventoryfree.capability.ILockedInventory;
import kirderf1.inventoryfree.capability.ModCapabilities;
import kirderf1.inventoryfree.client.ClientData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber(modid="inventory_free", value={Dist.CLIENT})
public class LockOverlay
extends AbstractWidget {
    private static final ResourceLocation LOCK = new ResourceLocation("inventory_free", "textures/item/lock.png");
    private static final int LOCK_BLIT = 200;
    private final AbstractContainerScreen<?> screen;

    public LockOverlay(AbstractContainerScreen<?> screen) {
        super(0, 0, 0, 0, CommonComponents.f_237098_);
        this.screen = screen;
    }

    public void m_87963_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        if (!InventoryFree.appliesTo((Player)mc.f_91074_)) {
            return;
        }
        RenderSystem.m_69482_();
        LockOverlay.getLockedInv(mc).ifPresent(lockedInv -> {
            for (Slot slot : this.screen.m_6262_().f_38839_) {
                if (!(slot instanceof BlockedSlot) || slot.m_6659_()) continue;
                LockOverlay.drawItem(poseStack, lockedInv.getStack(slot.getSlotIndex()), mc, this.screen.getGuiLeft() + slot.f_40220_, this.screen.getGuiTop() + slot.f_40221_);
            }
        });
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)LOCK);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        for (Slot slot : this.screen.m_6262_().f_38839_) {
            if (!(slot instanceof BlockedSlot) || slot.m_6659_()) continue;
            LockOverlay.m_93143_((PoseStack)poseStack, (int)(this.screen.getGuiLeft() + slot.f_40220_), (int)(this.screen.getGuiTop() + slot.f_40221_), (int)200, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
    }

    @SubscribeEvent
    public static void onHotbarOverlay(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == VanillaGuiOverlay.HOTBAR.type()) {
            Minecraft mc = Minecraft.m_91087_();
            PoseStack poseStack = event.getPoseStack();
            if (!InventoryFree.appliesTo((Player)mc.f_91074_) || ClientData.getAvailableSlots() >= 9) {
                return;
            }
            int scaledWidth = mc.m_91268_().m_85445_();
            int scaledHeight = mc.m_91268_().m_85446_();
            RenderSystem.m_69482_();
            LockOverlay.getLockedInv(mc).ifPresent(lockedInv -> {
                for (Slot slot : mc.f_91074_.f_36095_.f_38839_) {
                    if (slot.getSlotIndex() >= 9 || !(slot instanceof BlockedSlot) || slot.m_6659_()) continue;
                    int x = scaledWidth / 2 - 90 + (slot.getSlotIndex() * 20 + 2);
                    int y = scaledHeight - 16 - 3;
                    LockOverlay.drawItem(poseStack, lockedInv.getStack(slot.getSlotIndex()), mc, x, y);
                }
            });
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)LOCK);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            for (Slot slot : mc.f_91074_.f_36095_.f_38839_) {
                if (slot.getSlotIndex() >= 9 || !(slot instanceof BlockedSlot) || slot.m_6659_()) continue;
                int x = scaledWidth / 2 - 90 + (slot.getSlotIndex() * 20 + 2);
                int y = scaledHeight - 16 - 3;
                LockOverlay.m_93143_((PoseStack)poseStack, (int)x, (int)y, (int)200, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
        }
    }

    private static void drawItem(PoseStack poseStack, ItemStack stack, Minecraft mc, int x, int y) {
        if (!stack.m_41619_()) {
            mc.m_91291_().m_274369_(poseStack, stack, x, y);
            mc.m_91291_().m_274364_(poseStack, mc.f_91062_, stack, x, y, null);
        }
    }

    private static LazyOptional<ILockedInventory> getLockedInv(Minecraft mc) {
        if (mc.f_91074_ != null) {
            return mc.f_91074_.getCapability(ModCapabilities.LOCKED_INV_CAPABILITY);
        }
        return LazyOptional.empty();
    }

    public void m_168797_(NarrationElementOutput narrationElementOutput) {
    }
}

