/*
 * Decompiled with CFR 0.152.
 */
package kirderf1.inventoryfree.client;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.ParametersAreNonnullByDefault;
import kirderf1.inventoryfree.BlockedSlot;
import kirderf1.inventoryfree.InventoryFree;
import kirderf1.inventoryfree.capability.ILockedInventory;
import kirderf1.inventoryfree.capability.ModCapabilities;
import kirderf1.inventoryfree.client.ClientData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber(modid="inventory_free", value={Dist.CLIENT})
public class LockOverlay
extends AbstractWidget {
    private static final ResourceLocation LOCK = new ResourceLocation("inventory_free", "textures/item/lock.png");
    private static final int LOCK_BLIT = 200;
    private final AbstractContainerScreen<?> screen;

    public LockOverlay(AbstractContainerScreen<?> screen) {
        super(0, 0, 0, 0, CommonComponents.f_237098_);
        this.screen = screen;
    }

    protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        if (!InventoryFree.appliesTo((Player)mc.f_91074_)) {
            return;
        }
        RenderSystem.enableDepthTest();
        LockOverlay.getLockedInv(mc).ifPresent(lockedInv -> {
            for (Slot slot : this.screen.m_6262_().f_38839_) {
                if (!(slot instanceof BlockedSlot) || slot.m_6659_()) continue;
                LockOverlay.drawItem(graphics, lockedInv.getStack(slot.getSlotIndex()), mc, this.screen.getGuiLeft() + slot.f_40220_, this.screen.getGuiTop() + slot.f_40221_);
            }
        });
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        for (Slot slot : this.screen.m_6262_().f_38839_) {
            if (!(slot instanceof BlockedSlot) || slot.m_6659_()) continue;
            graphics.m_280398_(LOCK, this.screen.getGuiLeft() + slot.f_40220_, this.screen.getGuiTop() + slot.f_40221_, 200, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    @SubscribeEvent
    public static void onHotbarOverlay(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == VanillaGuiOverlay.HOTBAR.type()) {
            Minecraft mc = Minecraft.m_91087_();
            GuiGraphics graphics = event.getGuiGraphics();
            if (!InventoryFree.appliesTo((Player)mc.f_91074_) || ClientData.getAvailableSlots() >= 9) {
                return;
            }
            int scaledWidth = mc.m_91268_().m_85445_();
            int scaledHeight = mc.m_91268_().m_85446_();
            RenderSystem.enableDepthTest();
            LockOverlay.getLockedInv(mc).ifPresent(lockedInv -> {
                for (Slot slot : mc.f_91074_.f_36095_.f_38839_) {
                    if (slot.getSlotIndex() >= 9 || !(slot instanceof BlockedSlot) || slot.m_6659_()) continue;
                    int x = scaledWidth / 2 - 90 + (slot.getSlotIndex() * 20 + 2);
                    int y = scaledHeight - 16 - 3;
                    LockOverlay.drawItem(graphics, lockedInv.getStack(slot.getSlotIndex()), mc, x, y);
                }
            });
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            for (Slot slot : mc.f_91074_.f_36095_.f_38839_) {
                if (slot.getSlotIndex() >= 9 || !(slot instanceof BlockedSlot) || slot.m_6659_()) continue;
                int x = scaledWidth / 2 - 90 + (slot.getSlotIndex() * 20 + 2);
                int y = scaledHeight - 16 - 3;
                graphics.m_280398_(LOCK, x, y, 200, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
    }

    private static void drawItem(GuiGraphics graphics, ItemStack stack, Minecraft mc, int x, int y) {
        if (!stack.m_41619_()) {
            graphics.m_280480_(stack, x, y);
            graphics.m_280370_(mc.f_91062_, stack, x, y);
        }
    }

    private static LazyOptional<ILockedInventory> getLockedInv(Minecraft mc) {
        if (mc.f_91074_ != null) {
            return mc.f_91074_.getCapability(ModCapabilities.LOCKED_INV_CAPABILITY);
        }
        return LazyOptional.empty();
    }

    public void m_168797_(NarrationElementOutput narrationElementOutput) {
    }
}

